% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_survey_svyranktest.R
\name{ard_survey_svyranktest}
\alias{ard_survey_svyranktest}
\title{ARD Survey rank test}
\usage{
ard_survey_svyranktest(data, by, variables, test, ...)
}
\arguments{
\item{data}{(\code{survey.design})\cr
a survey design object often created with \code{\link[survey:svydesign]{survey::svydesign()}}}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column name to compare by}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
column names to be compared. Independent tests will be run for each variable.}

\item{test}{(\code{string})\cr
a string to denote which rank test to use:
\code{"wilcoxon"}, \code{"vanderWaerden"}, \code{"median"}, \code{"KruskalWallis"}}

\item{...}{arguments passed to \code{\link[survey:svyranktest]{survey::svyranktest()}}}
}
\value{
ARD data frame
}
\description{
Analysis results data for survey wilcox test using \code{\link[survey:svyranktest]{survey::svyranktest()}}.
}
\examples{
\dontshow{if (do.call(asNamespace("cardx")$is_pkg_installed, list(pkg = c("survey", "broom")))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(api, package = "survey")
dclus2 <- survey::svydesign(id = ~ dnum + snum, fpc = ~ fpc1 + fpc2, data = apiclus2)

ard_survey_svyranktest(dclus2, variables = enroll, by = comp.imp, test = "wilcoxon")
ard_survey_svyranktest(dclus2, variables = enroll, by = comp.imp, test = "vanderWaerden")
ard_survey_svyranktest(dclus2, variables = enroll, by = comp.imp, test = "median")
ard_survey_svyranktest(dclus2, variables = enroll, by = comp.imp, test = "KruskalWallis")
\dontshow{\}) # examplesIf}
}
