% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scurve.R
\name{gen_scurve}
\alias{gen_scurve}
\title{Generate S-curve Data}
\usage{
gen_scurve(n = 500, p = 4, noise_fun = gen_wavydims3, ...)
}
\arguments{
\item{n}{A numeric value (default: 500) representing the sample size.}

\item{p}{A numeric value (default: 4) representing the number of dimensions.}

\item{noise_fun}{A function specifying which noise generation function to use for the additional dimensions. Default is \code{gen_wavydims3}. Other options include \code{gen_wavydims1}, \code{gen_wavydims2}, and \code{gen_noisedims}.}

\item{...}{Additional arguments passed to the selected \code{noise_fun} (e.g., \code{m}, \code{s}, \code{theta}, \code{x1_vec}, \code{data}).}
}
\value{
A data containing the generated S-curve data.
}
\description{
This function generates S-curve data.
}
\examples{
set.seed(20240412)
scurve <- gen_scurve(n = 500, p = 4)
}
\references{
Buitinck, L., Louppe, G., Blondel, M., Pedregosa, F., Mueller, A.,
Grisel, O., ... & Varoquaux, G. (2013).
API design for machine learning software: experiences from the scikit-learn
project.
\emph{arXiv preprint} \emph{arXiv:1309.0238}.
}
