% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_estimators_weights.R
\name{calculateInnerWeightsPLS}
\alias{calculateInnerWeightsPLS}
\title{Internal: Calculate the inner weights for PLS-PM}
\usage{
calculateInnerWeightsPLS(
  .S                           = args_default()$.S,
  .W                           = args_default()$.W,
  .csem_model                  = args_default()$.csem_model,
  .PLS_ignore_structural_model = args_default()$.PLS_ignore_structrual_model,
  .PLS_weight_scheme_inner     = args_default()$.PLS_weight_scheme_inner
)
}
\arguments{
\item{.S}{The (K x K) empirical indicator correlation matrix.}

\item{.W}{A (J x K) matrix of weights.}

\item{.csem_model}{A (possibly incomplete) \link{cSEMModel}-list.}

\item{.PLS_ignore_structural_model}{Logical. Should the structural model be ignored
when calculating the inner weights of the PLS-PM algorithm? Defaults to \code{FALSE}.
Ignored if \code{.approach_weights} is not PLS-PM.}

\item{.PLS_weight_scheme_inner}{Character string. The inner weighting scheme
used by PLS-PM. One of: "\emph{centroid}", "\emph{factorial}", or "\emph{path}".
Defaults to "\emph{path}". Ignored if \code{.approach_weight} is not PLS-PM.}
}
\value{
The (J x J) matrix \code{E} of inner weights.
}
\description{
PLS-PM forms "inner" composites as a weighted sum of its \emph{I} related composites.
These inner weights are obtained using one of the following schemes \insertCite{Lohmoeller1989}{cSEM}:
\describe{
\item{\code{centroid}}{According to the centroid weighting scheme each inner weight used
to form composite \emph{j} is either 1 if the correlation between composite \emph{j} and
its via the structural model related composite \emph{i = 1, ..., I} is positive
and -1 if it is negative.}
\item{\code{factorial}}{According to the factorial weighting scheme each inner weight used
to form inner composite \emph{j} is equal to the correlation between composite \emph{j}
and its via the structural model related composite \emph{i = 1, ..., I}.}
\item{\code{path}}{Lets call all construct that have an arrow pointing to construct \emph{j}
\strong{predecessors of j} and all arrows going from j to other constructs \strong{followers of j}.
According the path weighting scheme, inner weights are computed as follows.
Take construct \emph{j}:
\itemize{
\item For all predecessors of \emph{j} set the inner weight of predecessor
\emph{i} to the correlation of \emph{i} with \emph{j}.
\item For all followers of \emph{j} set the inner weight of follower \emph{i} to
the coefficient of a multiple regression of \emph{j} on all
followers \emph{i} with \emph{i = 1,...,I}.
}}
}
Except for the path weighting scheme relatedness can come in two flavors.
If \code{.PLS_ignore_structural_model = TRUE} all constructs are considered related.
If \code{.PLS_ignore_structural_model = FALSE} (the default) only adjacent constructs
are considered. If \code{.PLS_ignore_structural_model = TRUE} and \code{.PLS_weight_scheme_inner = "path"}
a warning is issued and \code{.PLS_ignore_structural_model} is changed to \code{FALSE}.
}
\keyword{internal}
