% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_foreman.R
\name{calculateCorrectionFactors}
\alias{calculateCorrectionFactors}
\title{Internal: Calculate PLSc correction factors}
\usage{
calculateCorrectionFactors(
 .S               = args_default()$.S,
 .W               = args_default()$.W,
 .modes           = args_default()$.modes,
 .csem_model      = args_default()$.csem_model,
 .PLS_approach_cf = args_default()$.PLS_approach_cf
 )
}
\arguments{
\item{.S}{The (K x K) empirical indicator correlation matrix.}

\item{.W}{A (J x K) matrix of weights.}

\item{.modes}{A vector giving the mode for each construct in the form \code{"name" = "mode"}.
Only used internally.}

\item{.csem_model}{A (possibly incomplete) \link{cSEMModel}-list.}

\item{.PLS_approach_cf}{Character string. Approach used to obtain the correction
factors for PLSc. One of: "\emph{dist_squared_euclid}", "\emph{dist_euclid_weighted}",
"\emph{fisher_transformed}", "\emph{mean_arithmetic}", "\emph{mean_geometric}", "\emph{mean_harmonic}",
"\emph{geo_of_harmonic}". Defaults to "\emph{dist_squared_euclid}".
Ignored if \code{.disattenuate = FALSE} or if \code{.approach_weights} is not PLS-PM.}
}
\value{
A numeric vector of correction factors with element names equal
to the names of the J constructs used in the measurement model.
}
\description{
Calculates the correction factor used by PLSc.
}
\details{
Currently, seven approaches are available:

\itemize{
\item "dist_squared_euclid" (default)
\item "dist_euclid_weighted"
\item "fisher_transformed"
\item "mean_geometric"
\item "mean_harmonic"
\item "mean_arithmetic"
\item "geo_of_harmonic" (not yet implemented)
}

See \insertCite{Dijkstra2013}{cSEM} for details.
}
\references{
\insertAllCited{}
}
\keyword{internal}
