% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Generate_Choice}
\alias{Generate_Choice}
\title{Generate Observed Data from choice model}
\usage{
Generate_Choice(N, J, K, theta, as, bs, zeta, gamma, X, W, subject_ids,
  unique_subject_ids)
}
\arguments{
\item{N}{An \code{integer} for the number of observations.}

\item{J}{An \code{integer} for the number of items.}

\item{K}{An \code{integer} for the number of paired comparisons.}

\item{theta}{A \code{vector} of latent cognitive variables.}

\item{as}{A \code{vector} of length J with item discriminations.}

\item{bs}{A \code{vector} of length J with item locations.}

\item{zeta}{A \code{matrix} with dimensions N x V containing
random parameter estimates.}

\item{gamma}{A \code{vector} with dimensions P x 1 containing
fixed parameter estimates, where \eqn{P = P_1 + P_2}}

\item{X}{A \code{matrix} with dimensions N*K x P_1 containing
fixed effect design matrix without theta.}

\item{W}{A \code{matrix} with dimensions N*K x V containing
random effect variables.}

\item{subject_ids}{A \code{vector} with length NK x 1 containing
subject-choice IDs.}

\item{unique_subject_ids}{A \code{vector} with length N x 1 containing
unique subject IDs.}
}
\value{
A \code{list} that contains:

\describe{
\item{\code{Y}}{A \code{matrix} of dimension N by J}
\item{\code{C}}{A \code{vector} of length NK}
}
}
\description{
Generates observed cognitive and choice data from the IRT-Thurstone model.
}
\author{
Steven Andrew Culpepper and James Joseph Balamuta
}
