% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/c14_date_list_duplicates_mark.R,
%   R/c14_date_list_duplicates_remove.R
\name{duplicates}
\alias{duplicates}
\alias{mark_duplicates}
\alias{mark_duplicates.default}
\alias{mark_duplicates.c14_date_list}
\alias{remove_duplicates}
\alias{remove_duplicates.default}
\alias{remove_duplicates.c14_date_list}
\title{Mark and remove duplicates in a \strong{c14_date_list}}
\usage{
mark_duplicates(x)

\method{mark_duplicates}{default}(x)

\method{mark_duplicates}{c14_date_list}(x)

remove_duplicates(x)

\method{remove_duplicates}{default}(x)

\method{remove_duplicates}{c14_date_list}(x)
}
\arguments{
\item{x}{an object of class c14_date_list}
}
\value{
an object of class c14_date_list with the additional
columns \strong{duplicate_group} or \strong{duplicate_remove_log}
}
\description{
Duplicates are found in \code{c14bazAAR::mark_duplicates()}
by comparison of \strong{labnr}s.
Only dates with exactly equal \strong{labnr}s are considered duplicates.
Duplicate groups are numbered (from 0) and these numbers linked to
the individual dates in the new column \strong{duplicate_group}.
Duplicates can be removed with \code{c14bazAAR::remove_duplicates()}. \cr
While \code{c14bazAAR::mark_duplicates()} finds duplicates,
\code{c14bazAAR::remove_duplicates()} removes them by merging
all dates in a \strong{duplicate_group}. All non-equal variables in the
duplicate group are turned to \code{NA}. A new column
\strong{duplicate_remove_log} documents the variety of entries initially
provided (and partially lost by this hard merging operation).
\code{c14bazAAR::remove_duplicates()} needs the column \strong{duplicate_group}
and calls \code{c14bazAAR::mark_duplicates()} if it's missing.
}
\examples{
mark_duplicates(example_c14_date_list)

library(magrittr)
example_c14_date_list \%>\%
  mark_duplicates() \%>\%
  remove_duplicates()

}
