#' Los Griegos Peak plot2 fire-history data
#'
#' An fhx object with fire-history data from Los Griegos Peak, New Mexico.
#'
#' @format An fhx object with 26 series from 1366 to 2012 CE. Each series is a string with 5 characters.
"lgr2"

#' Metadata for the Los Griegos Peak fire-history dataset
#'
#' A dataset with species information for the Los Griegos Peak plot2 fire-history dataset (`lgr2`).
#'
#' @format A data frame with 26 rows and 2 variables:
#' \itemize{
#'   \item TreeID: name of tree series
#'   \item SpeciesID: abbreviated tree species
#' }
"lgr2_meta"

#' Peggy Mesa fire-history data
#'
#' An fhx object with fire-history data from Peggy Mesa. See dataset `pgm_meta` for metadata. Data from Guiterman, Christopher H., Ellis Q. Margolis, and Thomas W. Swetnam. 2015. "Dendroecological Methods For Reconstructing High-Severity Fire In Pine-Oak Forests." Tree-Ring Research 71 (2): 67-77. doi:10.3959/1536-1098-71.2.67.

#'
#' @format An fhx object with 41 series from 1555 to 2013 CE. Each series is a string with 5 characters.
"pgm"

#' Metadata for the Peggy Mesa fire-history dataset
#'
#' A dataset with species and location information for the Peggy Mesa fire-history dataset (`pgm`). Data from Guiterman, Christopher H., Ellis Q. Margolis, and Thomas W. Swetnam. 2015. "Dendroecological Methods For Reconstructing High-Severity Fire In Pine-Oak Forests." Tree-Ring Research 71 (2): 67-77. doi:10.3959/1536-1098-71.2.67.
#'
#' @format A data frame with 41 rows and 5 variables:
#' \itemize{
#'   \item TreeID: name of tree series
#'   \item SpeciesID: abbreviated tree species
#'   \item Latitude: latitude of tree in decimal degrees
#'   \item Longitude: longitude of tree in decimal degrees
#'   \item Elevation: tree elevation in meters
#' }
"pgm_meta"

#' Reconstructed PDSI time series for the Peggy Mesa fire-history dataset
#'
#' A tree-ring reconstructed Palmer Drought-Severity Index time series corresponding to the Peggy Mesa fire-history dataset (`pgm`) -- specifically, the Jemez Mountains area (gridpoint 133). The reconstruction is from The North American Drought Atlas (Cook and Krusic 2004).
#'
#' @format A data frame with 2004 rows and 1 variables. Row names give the year for the reconstructed value:
#' \itemize{
#'   \item RECON: The reconstructed PDSI series.
#' }
"pgm_pdsi"