% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.bsem}
\alias{plot.bsem}
\title{'bsem' object plot}
\usage{
\method{plot}{bsem}(x, digits = 2, fontsize = 15, width = 5, size = 10, ...)
}
\arguments{
\item{x}{an object of class bsem}

\item{digits}{number of digits to display}

\item{fontsize}{edge fontsize (estimates character size)}

\item{width}{lines width}

\item{size}{nodes size (for both: ellipses and boxes)}

\item{...}{further arguments passed to \code{visNetwork::visNetwork} function}
}
\value{
a visNetwork graph:
\describe{
   \item{}{The ellipsoidal nodes represent the latent variables}
   \item{}{The boxes represent the manifest variables}
   \item{}{The dashed lines represent the linear relations between latent scores or between latent scores and exogenous variables}
   \item{}{The solid lines represent the relationship between the manifest an latent variables}
   \item{}{The recursive solid lines refers to the error variance estimate of each manifest or exogenous variable}
}
}
\description{
'bsem' object plot
}
\examples{

dt <- bsem::simdata()
names(dt)
\donttest{

semfit <- bsem::sem(
  data = dt$data,
  blocks = dt$blocks,
  paths = dt$paths,
  exogenous = dt$exogenous,
  signals = dt$signals,
  cores = 1
)
plot(semfit)
}

}
\seealso{
\code{\link[bsem]{sem}}, \code{\link[bsem]{simdata}}, \code{\link[bsem]{arrayplot}}, \code{\link[bsem]{summary.bsem}}, \code{\link[bsem]{print.bsem}}
}
\author{
RVPanaro
}
