% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arcsine_distribution.R
\name{arcsine_distribution}
\alias{arcsine_distribution}
\alias{arcsine_pdf}
\alias{arcsine_lpdf}
\alias{arcsine_cdf}
\alias{arcsine_lcdf}
\alias{arcsine_quantile}
\title{Arcsine Distribution Functions}
\usage{
arcsine_distribution(x_min = 0, x_max = 1)

arcsine_pdf(x, x_min = 0, x_max = 1)

arcsine_lpdf(x, x_min = 0, x_max = 1)

arcsine_cdf(x, x_min = 0, x_max = 1)

arcsine_lcdf(x, x_min = 0, x_max = 1)

arcsine_quantile(p, x_min = 0, x_max = 1)
}
\arguments{
\item{x_min}{minimum value of the distribution (default is 0)}

\item{x_max}{maximum value of the distribution (default is 1)}

\item{x}{quantile}

\item{p}{probability}
}
\value{
A single numeric value with the computed probability density, log-probability density, cumulative distribution, log-cumulative distribution, or quantile depending on the function called.
}
\description{
Functions to compute the probability density function, cumulative distribution function, and quantile function for the arcsine distribution.
}
\examples{
# Arcsine distribution with default parameters
dist <- arcsine_distribution()
# Apply generic functions
cdf(dist, 0.5)
logcdf(dist, 0.5)
pdf(dist, 0.5)
logpdf(dist, 0.5)
hazard(dist, 0.5)
chf(dist, 0.5)
mean(dist)
median(dist)
range(dist)
quantile(dist, 0.2)
standard_deviation(dist)
support(dist)
variance(dist)
skewness(dist)
kurtosis(dist)
kurtosis_excess(dist)

# Convenience functions
arcsine_pdf(0.5)
arcsine_lpdf(0.5)
arcsine_cdf(0.5)
arcsine_lcdf(0.5)
arcsine_quantile(0.5)
}
\seealso{
\href{https://www.boost.org/doc/libs/latest/libs/math/doc/html/math_toolkit/dist_ref/dists/arcine_dist.html}{Boost Documentation} for more details on the mathematical background.
}
