% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributions.R
\name{IMMdist}
\alias{IMMdist}
\alias{dimm}
\alias{pimm}
\alias{qimm}
\alias{rimm}
\title{Distribution functions for the Interference Measurement Model (IMM)}
\usage{
dimm(
  x,
  mu = c(0, 2, -1.5),
  dist = c(0, 0.5, 2),
  c = 5,
  a = 2,
  b = 1,
  s = 2,
  kappa = 5,
  log = FALSE
)

pimm(
  q,
  mu = c(0, 2, -1.5),
  dist = c(0, 0.5, 2),
  c = 1,
  a = 0.2,
  b = 0,
  s = 2,
  kappa = 5
)

qimm(
  p,
  mu = c(0, 2, -1.5),
  dist = c(0, 0.5, 2),
  c = 1,
  a = 0.2,
  b = 0,
  s = 2,
  kappa = 5
)

rimm(
  n,
  mu = c(0, 2, -1.5),
  dist = c(0, 0.5, 2),
  c = 1,
  a = 0.2,
  b = 1,
  s = 2,
  kappa = 5
)
}
\arguments{
\item{x}{Vector of observed responses}

\item{mu}{Vector of locations}

\item{dist}{Vector of distances of the item locations to the cued location}

\item{c}{Vector of strengths for cue-dependent activation}

\item{a}{Vector of strengths for cue-independent activation}

\item{b}{Vector of baseline activation}

\item{s}{Vector of generalization gradients}

\item{kappa}{Vector of precision values}

\item{log}{Logical; if \code{TRUE}, values are returned on the log scale.}

\item{q}{Vector of quantiles}

\item{p}{Vector of probability}

\item{n}{Number of observations to generate data for}
}
\value{
\code{dimm} gives the density of the interference measurement model,
\code{pimm} gives the cumulative distribution function of the interference
measurement model, \code{qimm} gives the quantile function of the interference
measurement model, and \code{rimm} gives the random generation function for the
interference measurement model.
}
\description{
Density, distribution, and random generation functions for the
interference measurement model with the location of \code{mu}, strength of cue-
dependent activation \code{c}, strength of cue-independent activation \code{a}, the
generalization gradient \code{s}, and the precision of memory representations
\code{kappa}.
}
\examples{
# generate random samples from the imm and overlay the density
r <- rimm(10000, mu = c(0, 2, -1.5), dist = c(0, 0.5, 2),
          c = 5, a = 2, s = 2, b = 1, kappa = 4)
x <- seq(-pi,pi,length.out=10000)
d <- dimm(x, mu = c(0, 2, -1.5), dist = c(0, 0.5, 2),
          c = 5, a = 2, s = 2, b = 1, kappa = 4)
hist(r, breaks=60, freq=FALSE)
lines(x,d,type="l", col="red")

}
\references{
Oberauer, K., Stoneking, C., Wabersich, D., & Lin, H.-Y. (2017).
Hierarchical Bayesian measurement models for continuous reproduction of
visual features from working memory. Journal of Vision, 17(5), 11.
}
\keyword{distribution}
