% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_ed.R
\name{encoding2df}
\alias{encoding2df}
\title{Convert encoding to data frame}
\usage{
encoding2df(x, sort = FALSE)
}
\arguments{
\item{x}{encoding.}

\item{sort}{if \code{TRUE} rows are sorted according to elements.}
}
\value{
data frame with two columns. First column represents an index of a 
group in the supplied encoding and the second column contains all elements of 
the encoding.
}
\description{
Converts an encoding to a data frame.
}
\details{
The encoding is a list of groups to which elements of an alphabet 
should be reduced. All elements of the alphabet (all 
amino acids or all nucleotides) should appear in the encoding.
}
\examples{
enc1 = list(`1` = c("a", "t"), 
            `2` = c("g", "c"))
encoding2df(enc1)
}
\seealso{
\code{\link{calc_ed}}: calculate the encoding distance between two encodings.
\code{\link{validate_encoding}}: validate a structure of an encoding.
}
\keyword{manip}

