% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcs_estimation.R
\name{estimate_hetero_mixed_poisson}
\alias{estimate_hetero_mixed_poisson}
\title{Heterogeneous dose estimation (Mixed Poisson model)}
\usage{
estimate_hetero_mixed_poisson(
  case_data,
  fit_coeffs,
  fit_var_cov_mat,
  conf_int = 0.95,
  protracted_g_value = 1,
  gamma,
  gamma_error
)
}
\arguments{
\item{case_data}{Case data in data frame form.}

\item{fit_coeffs}{Fitting coefficients matrix.}

\item{fit_var_cov_mat}{Fitting variance-covariance matrix.}

\item{conf_int}{Confidence interval, 95\% by default.}

\item{protracted_g_value}{Protracted \eqn{G(x)} value.}

\item{gamma}{Survival coefficient of irradiated cells.}

\item{gamma_error}{Error of the survival coefficient of irradiated cells.}
}
\value{
List containing estimated mixing proportions data frame, estimated yields data
frame, estimated doses data frame, estimated fraction of irradiated blood data frame,
AIC, and \code{conf_int_*} used.
}
\description{
Method based on the paper by Pujol, M. et al. (2016). A New Model for
Biological Dose Assessment in Cases of Heterogeneous Exposures to Ionizing
Radiation. Radiation Research, 185(2), 151-162. <doi:10.1667/RR14145.1>.
}
