% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/billboarder-shiny.R
\name{bb_proxy_focus}
\alias{bb_proxy_focus}
\alias{bb_proxy_defocus}
\title{Highlights specified targets and fade out the others.}
\usage{
bb_proxy_focus(proxy, ids = NULL)

bb_proxy_defocus(proxy, ids = NULL)
}
\arguments{
\item{proxy}{A \code{billboardProxy} \code{htmlwidget} object.}

\item{ids}{Data ids (names) to be highlighted, if \code{NULL} all datas will be highlighted.}
}
\value{
A \code{billboardProxy} \code{htmlwidget} object.
}
\description{
Highlights specified targets and fade out the others.
}
\note{
\code{bb_defocus} is the opposite of \code{bb_focus}
}
\examples{
\dontrun{
if (interactive()) {
library("shiny")
library("billboarder")

ui <- fluidPage(
  tags$h1("Proxy method to highlight data"),
  checkboxGroupInput(
    inputId = "focus", 
    label = "Focus", 
    choices = c("setosa", "versicolor", "virginica"), 
    inline = TRUE
  ),
  billboarderOutput(outputId = "bb")
)

server <- function(input, output, session) {
  
  output$bb <- renderBillboarder({
    billboarder() \%>\% 
      bb_scatter(
        data = iris, 
        x = "Sepal.Length", 
        y = "Sepal.Width", 
        group = "Species"
      ) \%>\% 
      bb_axis(x = list(tick = list(fit = FALSE))) \%>\% 
      bb_point(r = 8)
  })
  
  observeEvent(input$focus, {
    billboarderProxy("bb") \%>\% 
      bb_proxy_focus(input$focus)
  }, ignoreNULL = FALSE)
}

shinyApp(ui = ui, server = server)
}
}
}
