% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bb_helpers.R
\name{bb_donutchart}
\alias{bb_donutchart}
\title{Helper for creating a donut chart}
\usage{
bb_donutchart(bb, data, mapping = NULL, ...)
}
\arguments{
\item{bb}{A \code{billboard} \code{htmlwidget} object.}

\item{data}{A \code{data.frame}.}

\item{mapping}{Mapping of variables on the chart, see \code{\link{bbaes}}.}

\item{...}{Arguments for slot donut, \url{https://naver.github.io/billboard.js/release/latest/doc/Options.html#.donut}.}
}
\value{
A \code{billboard} \code{htmlwidget} object.
}
\description{
Helper for creating a donut chart
}
\note{
This function can be used with \code{\link{billboarderProxy}} in shiny application.
}
\examples{
\dontrun{
stars <- data.frame(
  package = c("billboarder", "ggiraph", "officer", "shinyWidgets", "visNetwork"),
  stars = c(9, 177, 43, 44, 169)
)

billboarder() \%>\% 
  bb_donutchart(data = stars, title = "Stars")
}
}
