% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bigsimr.R
\name{bigsimr_setup}
\alias{bigsimr_setup}
\title{Setup bigsimr}
\usage{
bigsimr_setup(pkg_check = TRUE, ...)
}
\arguments{
\item{pkg_check}{logical, check for Bigsimr.jl package and install if necessary}

\item{...}{Parameters are passed down to JuliaCall::julia_setup}
}
\value{
Return the imported wrapper of Bigsimr.jl Julia package
}
\description{
This function initializes Julia and the Bigsimr.jl package.
The first time will be long since it includes precompilation.
Additionally, this will install Julia and the required packages
if they are missing.
}
\examples{
\donttest{
library(bigsimr)
bs   <- bigsimr::bigsimr_setup()
dist <- bigsimr::distributions_setup()

JuliaCall::julia_eval('using Random; Random.seed!(1);')
# Generate random target correlation matrix
target_corr <- bs$cor_randPD(3)
# Set the margins of variables
margins <- c(dist$Binomial(20, 0.2), dist$Beta(2, 3), dist$LogNormal(3, 1))
# Adjust target correlation matrix using Pearson matching
adjusted_corr <- bs$pearson_match(target_corr, margins)
# Generate random vectors
x <- bs$rvec(10000, adjusted_corr, margins)
}
}
