% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bfastlite.R
\name{bfastlite}
\alias{bfastlite}
\alias{bfast0n}
\title{Detect multiple breaks in a time series}
\usage{
bfastlite(
  data,
  formula = response ~ trend + harmon,
  order = 3,
  breaks = "LWZ",
  lag = NULL,
  slag = NULL,
  na.action = na.omit,
  stl = c("none", "trend", "seasonal", "both"),
  decomp = c("stl", "stlplus"),
  sbins = 1,
  ...
)

bfast0n(
  data,
  formula = response ~ trend + harmon,
  order = 3,
  breaks = "LWZ",
  lag = NULL,
  slag = NULL,
  na.action = na.omit,
  stl = c("none", "trend", "seasonal", "both"),
  decomp = c("stl", "stlplus"),
  sbins = 1,
  ...
)
}
\arguments{
\item{data}{A time series of class \code{\link[stats]{ts}}, or another
object that can be coerced to such. For seasonal components, a frequency
greater than 1 is required.}

\item{formula}{a symbolic description for the model in which breakpoints
    will be estimated.}

\item{order}{numeric. Order of the harmonic term, defaulting to \code{3}.}

\item{breaks}{either a positive integer specifying the maximal number of breaks to be calculated,
    or a string specifying the information criterion to use to automatically determine
    the optimal number of breaks (see also \code{\link{logLik}}.
    \code{"all"} means the maximal number allowed by \code{h} is used.
    \code{NULL} is treated as the default of the \code{breakpoints} function (i.e. BIC).}

\item{lag}{numeric. Orders of the autoregressive term, by default omitted.}

\item{slag}{numeric. Orders of the seasonal autoregressive term, by default
omitted.}

\item{na.action}{function for handling \code{NA}s in the data (after all
other preprocessing).}

\item{stl}{character. Prior to all other preprocessing, STL (season-trend
decomposition via LOESS smoothing) can be employed for trend-adjustment
and/or season-adjustment.  The \code{"trend"} or \code{"seasonal"} component
or both from \code{\link[stats]{stl}} are removed from each column in
\code{data}. By default (\code{"none"}), no STL adjustment is used.}

\item{decomp}{"stlplus" or "stl": use the NA-tolerant decomposition package
or the reference package (which can make use of time series with 2-3
observations per year)}

\item{sbins}{numeric. Controls the number of seasonal dummies. If integer > 1,
sets the number of seasonal dummies to use per year.
If <= 1, treated as a multiplier to the number of observations per year, i.e.
\code{ndummies = nobs/year * sbins}.}

\item{...}{Additional arguments to \code{\link[strucchangeRcpp]{breakpoints}}.}
}
\value{
An object of class \code{bfastlite}, with two elements:
\item{breakpoints}{output from \code{\link[strucchangeRcpp]{breakpoints}},
containing information about the estimated breakpoints.}
\item{data_pp}{preprocessed data as output by \code{\link{bfastpp}}.}
}
\description{
A combination of \code{\link{bfastpp}} and \code{\link[strucchangeRcpp]{breakpoints}}
to do light-weight detection of multiple breaks in a time series
while also being able to deal with NA values by excluding them
via \code{bfastpp}.
}
\examples{
plot(simts) # stl object containing simulated NDVI time series
datats <- ts(rowSums(simts$time.series))
# sum of all the components (season,abrupt,remainder)
tsp(datats) <- tsp(simts$time.series) # assign correct time series attributes
plot(datats)

# Detect breaks
bp = bfastlite(datats)

# Default method of estimating breakpoints
bp[["breakpoints"]][["breakpoints"]]

# Plot
plot(bp)

# Custom method of estimating number of breaks (request 2 breaks)
strucchangeRcpp::breakpoints(bp[["breakpoints"]], breaks = 2)

# Plot including magnitude based on RMSD for the cos1 component of harmonics
plot(bp, magstat = "RMSD", magcomp = "harmoncos1", breaks = 2)
}
\author{
Dainius Masiliunas, Jan Verbesselt
}
