% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/em_aic.R
\name{em_aic}
\alias{em_aic}
\title{Akaike Information Criterion}
\usage{
em_aic(llk, C, M, N, R, model_name = "K..")
}
\arguments{
\item{llk}{Log-likelihood value.}

\item{C}{Number of CpG sites.}

\item{M}{Number of methylation states identified in a DNA sample.}

\item{N}{Number of patients.}

\item{R}{Number of DNA sample types collected from each patient.}

\item{model_name}{Fitted mixture model. Options are "K..", "KN." and/or "K.R" (default = "K..").}
}
\value{
The AIC value for the selected model.
}
\description{
Compute the AIC value for the optimal model.
}
\details{
Computes the AIC for a specified model given the log-likelihood, the dimension of the data, and the model names.
}
\seealso{
\code{\link{em_bic}}

\code{\link{em_icl}}
}
