% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaNB-p-cor-nb.R
\name{PCorNB}
\alias{PCorNB}
\title{Estimate Squared Partial Correlation Coefficients
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping}
\usage{
PCorNB(object, alpha = c(0.05, 0.01, 0.001))
}
\arguments{
\item{object}{Object of class \code{nb}, that is,
the output of the \code{NB()} function.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.}
}
\value{
Returns an object
of class \code{betanb} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{thetahatstar}{Sampling distribution of
\eqn{r^{2}_{p}}.}
\item{vcov}{Sampling variance-covariance matrix of
\eqn{r^{2}_{p}}.}
\item{est}{Vector of estimated
\eqn{r^{2}_{p}}.}
\item{fun}{Function used ("PCorNB").}
}
}
\description{
Estimate Squared Partial Correlation Coefficients
and Generate the Corresponding Sampling Distribution
Using Nonparametric Bootstrapping
}
\details{
The vector of squared partial correlation coefficients
(\eqn{r^{2}_{p}})
is estimated from bootstrap samples.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of \eqn{r^{2}_{p}},
where \eqn{\alpha} is the significance level.
}
\examples{
# Data ---------------------------------------------------------------------
data("nas1982", package = "betaNB")

# Fit Model in lm ----------------------------------------------------------
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)

# NB -----------------------------------------------------------------------
nb <- NB(
  object,
  R = 100, # use a large value e.g., 5000L for actual research
  seed = 0508
)

# PCorNB -------------------------------------------------------------------
out <- PCorNB(nb, alpha = 0.05)

## Methods -----------------------------------------------------------------
print(out)
summary(out)
coef(out)
vcov(out)
confint(out, level = 0.95)

}
\seealso{
Other Beta Nonparametric Bootstrap Functions: 
\code{\link{BetaNB}()},
\code{\link{DeltaRSqNB}()},
\code{\link{DiffBetaNB}()},
\code{\link{NB}()},
\code{\link{RSqNB}()},
\code{\link{SCorNB}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Nonparametric Bootstrap Functions}
\keyword{betaNB}
\keyword{pcor}
