% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/betaMC-delta-r-sq-mc.R
\name{DeltaRSqMC}
\alias{DeltaRSqMC}
\title{Estimate Improvement in R-Squared
and Generate the Corresponding Sampling Distribution
Using the Monte Carlo Method}
\usage{
DeltaRSqMC(object, alpha = c(0.05, 0.01, 0.001))
}
\arguments{
\item{object}{Object of class \code{mc}, that is,
the output of the \code{MC()} function.}

\item{alpha}{Numeric vector.
Significance level \eqn{\alpha}.}
}
\value{
Returns an object
of class \code{betamc} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{thetahatstar}{Sampling distribution of
\eqn{\Delta R^{2}}.}
\item{vcov}{Sampling variance-covariance matrix of
\eqn{\Delta R^{2}}.}
\item{est}{Vector of estimated
\eqn{\Delta R^{2}}.}
\item{fun}{Function used ("DeltaRSqMC").}
}
}
\description{
Estimate Improvement in R-Squared
and Generate the Corresponding Sampling Distribution
Using the Monte Carlo Method
}
\details{
The vector of improvement in R-squared
(\eqn{\Delta R^{2}})
is derived from each randomly generated vector of parameter estimates.
Confidence intervals are generated by obtaining
percentiles corresponding to \eqn{100(1 - \alpha)\%}
from the generated sampling
distribution of \eqn{\Delta R^{2}},
where \eqn{\alpha} is the significance level.
}
\examples{
# Data ---------------------------------------------------------------------
data("nas1982", package = "betaMC")

# Fit Model in lm ----------------------------------------------------------
object <- lm(QUALITY ~ NARTIC + PCTGRT + PCTSUPP, data = nas1982)

# MC -----------------------------------------------------------------------
mc <- MC(
  object,
  R = 100, # use a large value e.g., 20000L for actual research
  seed = 0508
)

# DeltaRSqMC ---------------------------------------------------------------
out <- DeltaRSqMC(mc, alpha = 0.05)

## Methods -----------------------------------------------------------------
print(out)
summary(out)
coef(out)
vcov(out)
confint(out, level = 0.95)

}
\seealso{
Other Beta Monte Carlo Functions: 
\code{\link{BetaMC}()},
\code{\link{DiffBetaMC}()},
\code{\link{MCMI}()},
\code{\link{MC}()},
\code{\link{PCorMC}()},
\code{\link{RSqMC}()},
\code{\link{SCorMC}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Beta Monte Carlo Functions}
\keyword{betaMC}
\keyword{deltarsq}
