% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.error.R
\name{is.error}
\alias{is.error}
\title{Check if an expression returns an error}
\usage{
is.error(expr, tell = FALSE, force = FALSE)
}
\arguments{
\item{expr}{Expression to be tested for retunrning an error}

\item{tell}{Logical: Should the error message be printed via \code{\link{message}}? DEFAULT: FALSE}

\item{force}{Logical: Should an error be returned if the expression is not an error? DEFAULT: FALSE}
}
\value{
TRUE/FALSE
}
\description{
Does a given expression return an error?
Useful for tests where you want to make sure your function throws an error.
}
\examples{
is.error(  log(3)              )
is.error(  log("a")            )
is.error(  log(3),   tell=TRUE )
is.error(  log("a"), tell=TRUE )
stopifnot( is.error( log("a")  )  ) # or shorter:
is.error(  log("a"), force=TRUE) 
# is.error(  log(3),   force=TRUE)
stopifnot(is.error(  is.error(log(3), force=TRUE)  ))

}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, May 2016
}
\seealso{
\code{\link{stop}}, \code{\link{try}}, \code{\link{inherits}}
}
\keyword{error}
\keyword{programming}

