% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_mcmc_filenames.R
\name{rename_mcmc_filenames}
\alias{rename_mcmc_filenames}
\title{Rename the filenames within an MCMC}
\usage{
rename_mcmc_filenames(mcmc, rename_fun)
}
\arguments{
\item{mcmc}{one MCMC.
Use \code{\link{create_mcmc}} to create an MCMC.
Use \code{\link{create_ns_mcmc}} to create an MCMC
  for a Nested Sampling run.
Use \code{\link{check_mcmc}} to check if an MCMC is valid.
Use \code{\link{rename_mcmc_filenames}} to rename the filenames in an MCMC.}

\item{rename_fun}{a function to rename a filename,
as can be checked by \link{check_rename_fun}. This function should
have one argument, which will be a filename or \link{NA}. The
function should \link{return} one filename (when passed one filename) or
one \link{NA} (when passed one \link{NA}).
Example rename functions are:
\itemize{
  \item \link{get_remove_dir_fun} get a function that removes the directory
    paths from the filenames, in effect turning these into local files
  \item \link{get_replace_dir_fun} get a function that replaces the directory
    paths from the filenames
  \item \link{get_remove_hex_fun} get a function that removes the
    hex string from filenames.
    For example, \code{tracelog_82c1a522040.log} becomes \code{tracelog.log}
}}
}
\description{
Rename the filenames within an MCMC
}
\examples{

# Create an MCMC with local filenames
mcmc <- create_mcmc()
mcmc$tracelog$filename <- "trace.log"
mcmc$screenlog$filename <- "screen.log"
mcmc$treelog$filename <- "tree.log"

# Nah, files should be put in '/home/john' folder
mcmc <- rename_mcmc_filenames(
  mcmc = mcmc,
  rename_fun = get_replace_dir_fun("/home/john")
)

# Nah, files should be put in '/home/doe' folder instead
mcmc <- rename_mcmc_filenames(
  mcmc = mcmc,
  rename_fun = get_replace_dir_fun("/home/doe")
)

# Nah, files should be put in local folder instead
mcmc <- rename_mcmc_filenames(
  mcmc = mcmc,
  rename_fun = get_remove_dir_fun()
)
}
