% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_beast2_input_run.R
\name{create_beast2_input_run}
\alias{create_beast2_input_run}
\title{Creates the '\code{run}' section of a BEAST2 XML parameter file}
\usage{
create_beast2_input_run(
  input_filename,
  inference_model = beautier::create_inference_model()
)
}
\arguments{
\item{input_filename}{A FASTA filename.
Use \code{\link{get_fasta_filename}} to obtain a testing FASTA filename.}

\item{inference_model}{a Bayesian phylogenetic inference model.
An inference model is the complete model setup in which a site model,
clock model, tree prior and more are specified.
Use \link{create_inference_model} to create an inference model.
Use \link{check_inference_model} to check if  an inference model is valid.
Use \link{rename_inference_model_filenames} to rename the files in an
inference model.}
}
\value{
lines of XML text
}
\description{
Creates the '\code{run}' section of a BEAST2 XML parameter file,
without being indented.
}
\details{
The \code{run} tag has these elements:
\preformatted{
   <run[...]>
       <state[...]>
       [...]
       </state>
       <init[...]>
       [...]
       </init>
       <distribution[...]>
       [...]
       </distribution>
       [operator ids]
       [loggers]
    </run>
}
}
\seealso{
Use \link{create_beast2_input_state}
to create the XML text of the \code{state} tag.
Use \link{create_beast2_input_init}
to create the XML text of the \code{init} tag.
Use \link{create_beast2_input_distr}
to create the XML text of the \code{distribution} tag.
Use \link{create_beast2_input_operators}
to create the XML text of the \code{[operator ids]} section.
Use \link{create_loggers_xml}
to create the XML text of the \code{[loggers]} part.
}
\author{
Richèl J.C. Bilderbeek
}
