% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_remove_hex_fun.R
\name{get_remove_hex_fun}
\alias{get_remove_hex_fun}
\title{Get a function that removes the hex string from filenames.}
\usage{
get_remove_hex_fun()
}
\description{
The default filenames created by \link{beautier} are temporary files,
such as \code{/home/john/.cache/tracelog_82c5888db98.log} (on Linux),
where \code{/home/john/.cache} is the location to a temporary folder
(on Linux) and \code{tracelog_82c5888db98.log} the filename.
The filename ends with a hex string (as is common for temporary files,
as \link{tempfile} does so). Because \link{beautier} puts an underscore
between the filename description (\code{tracelog}) and the hex
string, this function removes both.
}
\examples{

f <- get_remove_hex_fun()
# /home/john/beast2.xml.state
f("/home/john/beast2_186c7404208c.xml.state")

# beast2.xml.state
f("beast2_186c7404208c.xml.state")

# NA
f(NA)
}
\author{
Richèl J.C. Bilderbeek
}
