% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beanz_stan.R
\name{call.stan}
\alias{call.stan}
\title{Call STAN models}
\usage{
call.stan(mdls = c("nse", "fs", "sr", "bs", "srs", "ds", "eds"), dat.sub,
  var.estvar, var.cov, lst.par.pri, var.nom = NULL, ...)
}
\arguments{
\item{mdls}{name of the Bayesian HTE model. The options are:

\describe{
  \item{nse}{No subgroup effect model}
  \item{fs}{Full stratification model}
  \item{sr}{Simple regression model}
  \item{bs}{Basic shrinkage model}
  \item{srs}{Simple regression with shrinkage model}
  \item{ds}{Dixon-Simon model}
  \item{eds}{Extended Dixon-Simon model}
}}

\item{dat.sub}{dataset with subgroup treatment effect summary data}

\item{var.estvar}{column names in dat.sub that corresponds to treatment effect
estimation and the estimated variance}

\item{var.cov}{array of column names in dat.sub that corresponds to binary or
ordinal baseline covaraites}

\item{lst.par.pri}{list of prior parameters for each model:

\describe{
  \item{nse, fs}{\code{vtau}, \code{vrange} for (\eqn{\Delta_1, \Delta_2})}
  \item{sr}{\code{vtau}, \code{vgamma}, \code{vrange}}
  \item{bs, ds, eds}{\code{vtau}, \code{vw}, \code{vrange}}
  \item{srs}{\code{vtau}, \code{vw}, \code{vgamma}, \code{vrange}}
}}

\item{var.nom}{array of column names in dat.sub that corresponds to nominal
baseline covariates}

\item{...}{options to call STAN sampling. These options include
\code{chains}, \code{iter}, \code{warmup}, \code{thin}, \code{algorithm}.
See \code{rstan::sampling} for details.}
}
\value{
A class \code{beanz.stan} list containing
 \describe{
   \item{mdl}{name of the Bayesian HTE model}
   \item{stan.rst}{raw \code{rstan} \code{sampling} results}
   \item{smps}{matrix of the posterior samples}
   \item{get.mus}{method to return the posterior sample of the subgroup treatment effects}
   \item{DIC}{DIC value}
}
}
\description{
Call STAN to draw posterior samples for Bayesian HTE models.
}
\examples{
\dontrun{
var.cov    <- c("sodium", "lvef", "any.vasodilator.use");
var.resp   <- "y";
var.trt    <- "trt";
var.censor <- "censor";
resptype   <- "survival";
var.estvar <- c("Estimate", "Variance");

subgrp.effect <- r.get.subgrp.raw(solvd.sub,
                                  var.resp   = var.resp,
                                  var.trt    = var.trt,
                                  var.cov    = var.cov,
                                  var.censor = var.censor,
                                  resptype   = resptype);

rst.nse    <- call.stan("nse", dat.sub=subgrp.effect,
                         var.estvar = var.estvar, var.cov = var.cov,
                         lst.par.pri = list(vtau=1000, vrange=c(0,0)),
                         chains=1, iter=4000,
                         warmup=2000, thin=2, seed=1000);
rst.sr     <- call.stan("sr", dat.sub=subgrp.effect,
                        var.estvar=var.estvar, var.cov = var.cov,
                        lst.par.pri=list(vtau=1000, vgamma=1000, vrange=c(0,0)),
                        chains=1, iter=4000,
                        warmup=2000, thin=2, seed=1000)};
}

