% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posterior_predict.R
\name{posterior_predict}
\alias{posterior_predict}
\alias{posterior_predict.bayesnecfit}
\alias{posterior_predict.bayesmanecfit}
\title{Generates posterior predictions for objects fitted by \code{\link{bnec}}}
\usage{
\method{posterior_predict}{bayesnecfit}(object, ...)

\method{posterior_predict}{bayesmanecfit}(object, ...)
}
\arguments{
\item{object}{An object of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}.}

\item{...}{Additional arguments to
\code{\link[brms]{posterior_predict}}.}
}
\value{
See \code{?brms::posterior_predict}.
}
\description{
Generates posterior predictions for objects fitted by \code{\link{bnec}}.
\code{object} should be of class \code{\link{bayesnecfit}} or
\code{\link{bayesmanecfit}}.
}
\examples{
\dontrun{
library(bayesnec)
# Uses default `resolution` and `x_range` to generate `newdata` internally
posterior_predict(manec_example)
# Provide user-specified `newdata`
nd_ <- data.frame(x = seq(0, 3, length.out = 200))
ppreds <- posterior_predict(manec_example, ecx_val = 50, newdata = nd_,
                            make_newdata = FALSE)
ncol(ppreds) == 200 # cols are x, rows are iterations
# Posterior predictions for raw input data
nec4param <- pull_out(manec_example, model = "nec4param")
preds <- posterior_predict(nec4param, make_newdata = FALSE)
x <- pull_brmsfit(nec4param)$data$x
plot(sort(x), preds[1, order(x)], type = "l", col = alpha("black", 0.1),
     ylim = c(-8, 5))
for (i in seq_len(nrow(preds))[-1]) {
  lines(sort(x), preds[i, order(x)], type = "l", col = alpha("black", 0.1))
}
}
}
