// Generated by rstantools.  Do not edit by hand.

/*
    bakR is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    bakR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with bakR.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_Hybrid_NSS_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 17, column 2 to column 24)",
                                                      " (in 'string', line 18, column 2 to column 20)",
                                                      " (in 'string', line 19, column 2 to column 25)",
                                                      " (in 'string', line 22, column 2 to column 27)",
                                                      " (in 'string', line 23, column 2 to column 25)",
                                                      " (in 'string', line 24, column 2 to column 16)",
                                                      " (in 'string', line 25, column 2 to column 30)",
                                                      " (in 'string', line 26, column 2 to column 25)",
                                                      " (in 'string', line 30, column 2 to column 38)",
                                                      " (in 'string', line 32, column 2 to column 48)",
                                                      " (in 'string', line 33, column 2 to column 35)",
                                                      " (in 'string', line 39, column 10 to column 81)",
                                                      " (in 'string', line 44, column 14 to column 79)",
                                                      " (in 'string', line 43, column 26 to line 45, column 11)",
                                                      " (in 'string', line 43, column 10 to line 45, column 11)",
                                                      " (in 'string', line 37, column 22 to line 46, column 8)",
                                                      " (in 'string', line 37, column 7 to line 46, column 8)",
                                                      " (in 'string', line 36, column 20 to line 47, column 5)",
                                                      " (in 'string', line 36, column 4 to line 47, column 5)",
                                                      " (in 'string', line 79, column 3 to column 22)",
                                                      " (in 'string', line 80, column 3 to column 29)",
                                                      " (in 'string', line 81, column 3 to column 26)",
                                                      " (in 'string', line 87, column 8 to column 56)",
                                                      " (in 'string', line 86, column 11 to line 88, column 7)",
                                                      " (in 'string', line 85, column 8 to column 52)",
                                                      " (in 'string', line 84, column 20 to line 86, column 7)",
                                                      " (in 'string', line 84, column 6 to line 88, column 7)",
                                                      " (in 'string', line 90, column 6 to column 33)",
                                                      " (in 'string', line 83, column 21 to line 91, column 5)",
                                                      " (in 'string', line 83, column 4 to line 91, column 5)",
                                                      " (in 'string', line 96, column 8 to column 49)",
                                                      " (in 'string', line 95, column 11 to line 97, column 7)",
                                                      " (in 'string', line 94, column 8 to column 50)",
                                                      " (in 'string', line 93, column 20 to line 95, column 7)",
                                                      " (in 'string', line 93, column 6 to line 97, column 7)",
                                                      " (in 'string', line 92, column 21 to line 98, column 5)",
                                                      " (in 'string', line 92, column 4 to line 98, column 5)",
                                                      " (in 'string', line 82, column 18 to line 99, column 3)",
                                                      " (in 'string', line 82, column 2 to line 99, column 3)",
                                                      " (in 'string', line 51, column 2 to column 26)",
                                                      " (in 'string', line 52, column 2 to column 31)",
                                                      " (in 'string', line 53, column 2 to column 23)",
                                                      " (in 'string', line 54, column 2 to column 25)",
                                                      " (in 'string', line 55, column 2 to column 31)",
                                                      " (in 'string', line 59, column 4 to column 27)",
                                                      " (in 'string', line 61, column 6 to column 47)",
                                                      " (in 'string', line 64, column 6 to column 35)",
                                                      " (in 'string', line 63, column 21 to line 65, column 6)",
                                                      " (in 'string', line 63, column 5 to line 65, column 6)",
                                                      " (in 'string', line 60, column 19 to line 66, column 5)",
                                                      " (in 'string', line 60, column 4 to line 66, column 5)",
                                                      " (in 'string', line 56, column 18 to line 67, column 3)",
                                                      " (in 'string', line 56, column 2 to line 67, column 3)",
                                                      " (in 'string', line 70, column 8 to column 81)",
                                                      " (in 'string', line 69, column 20 to line 76, column 5)",
                                                      " (in 'string', line 69, column 4 to line 76, column 5)",
                                                      " (in 'string', line 3, column 2 to column 9)",
                                                      " (in 'string', line 4, column 2 to column 9)",
                                                      " (in 'string', line 5, column 9 to column 11)",
                                                      " (in 'string', line 5, column 2 to column 13)",
                                                      " (in 'string', line 6, column 2 to column 10)",
                                                      " (in 'string', line 7, column 9 to column 11)",
                                                      " (in 'string', line 7, column 2 to column 13)",
                                                      " (in 'string', line 8, column 8 to column 10)",
                                                      " (in 'string', line 8, column 2 to column 12)",
                                                      " (in 'string', line 9, column 2 to column 11)",
                                                      " (in 'string', line 10, column 10 to column 13)",
                                                      " (in 'string', line 10, column 2 to column 15)",
                                                      " (in 'string', line 11, column 20 to column 22)",
                                                      " (in 'string', line 11, column 2 to column 24)",
                                                      " (in 'string', line 12, column 13 to column 15)",
                                                      " (in 'string', line 12, column 2 to column 18)",
                                                      " (in 'string', line 13, column 17 to column 19)",
                                                      " (in 'string', line 13, column 21 to column 24)",
                                                      " (in 'string', line 13, column 2 to column 26)",
                                                      " (in 'string', line 14, column 2 to column 30)",
                                                      " (in 'string', line 17, column 20 to column 22)",
                                                      " (in 'string', line 17, column 9 to column 12)",
                                                      " (in 'string', line 18, column 9 to column 12)",
                                                      " (in 'string', line 19, column 9 to column 12)",
                                                      " (in 'string', line 22, column 12 to column 14)",
                                                      " (in 'string', line 22, column 16 to column 19)",
                                                      " (in 'string', line 22, column 21 to column 25)",
                                                      " (in 'string', line 23, column 18 to column 21)",
                                                      " (in 'string', line 24, column 9 to column 12)",
                                                      " (in 'string', line 25, column 18 to column 21)",
                                                      " (in 'string', line 26, column 21 to column 23)",
                                                      " (in 'string', line 26, column 9 to column 12)",
                                                      " (in 'string', line 30, column 23 to column 25)",
                                                      " (in 'string', line 30, column 27 to column 30)",
                                                      " (in 'string', line 30, column 32 to column 36)",
                                                      " (in 'string', line 32, column 18 to column 21)",
                                                      " (in 'string', line 33, column 31 to column 33)",
                                                      " (in 'string', line 33, column 18 to column 21)",
                                                      " (in 'string', line 79, column 18 to column 20)",
                                                      " (in 'string', line 79, column 10 to column 13)",
                                                      " (in 'string', line 80, column 25 to column 27)",
                                                      " (in 'string', line 80, column 10 to column 15)",
                                                      " (in 'string', line 81, column 22 to column 24)",
                                                      " (in 'string', line 81, column 10 to column 13)"};
#include <stan_meta_header.hpp>
class model_Hybrid_NSS final : public model_base_crtp<model_Hybrid_NSS> {
private:
  int NE;
  int NF;
  std::vector<int> MT;
  int nMT;
  std::vector<int> FE;
  std::vector<int> R;
  int nrep;
  std::vector<double> tl;
  std::vector<double> logit_fn_rep;
  std::vector<double> fn_se;
  std::vector<std::vector<double>> Avg_Reads;
  int Chase;
  int L2FC_kd_2dim__;
 
public:
  ~model_Hybrid_NSS() { }
  
  inline std::string model_name() const final { return "model_Hybrid_NSS"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_Hybrid_NSS(stan::io::var_context& context__,
                   unsigned int random_seed__ = 0,
                   std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_Hybrid_NSS_namespace::model_Hybrid_NSS";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 57;
      context__.validate_dims("data initialization","NE","int",
          context__.to_vec());
      NE = std::numeric_limits<int>::min();
      
      current_statement__ = 57;
      NE = context__.vals_i("NE")[(1 - 1)];
      current_statement__ = 58;
      context__.validate_dims("data initialization","NF","int",
          context__.to_vec());
      NF = std::numeric_limits<int>::min();
      
      current_statement__ = 58;
      NF = context__.vals_i("NF")[(1 - 1)];
      current_statement__ = 59;
      validate_non_negative_index("MT", "NE", NE);
      current_statement__ = 60;
      context__.validate_dims("data initialization","MT","int",
          context__.to_vec(NE));
      MT = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 60;
      assign(MT, nil_index_list(), context__.vals_i("MT"),
        "assigning variable MT");
      current_statement__ = 61;
      context__.validate_dims("data initialization","nMT","int",
          context__.to_vec());
      nMT = std::numeric_limits<int>::min();
      
      current_statement__ = 61;
      nMT = context__.vals_i("nMT")[(1 - 1)];
      current_statement__ = 62;
      validate_non_negative_index("FE", "NE", NE);
      current_statement__ = 63;
      context__.validate_dims("data initialization","FE","int",
          context__.to_vec(NE));
      FE = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 63;
      assign(FE, nil_index_list(), context__.vals_i("FE"),
        "assigning variable FE");
      current_statement__ = 64;
      validate_non_negative_index("R", "NE", NE);
      current_statement__ = 65;
      context__.validate_dims("data initialization","R","int",
          context__.to_vec(NE));
      R = std::vector<int>(NE, std::numeric_limits<int>::min());
      
      current_statement__ = 65;
      assign(R, nil_index_list(), context__.vals_i("R"),
        "assigning variable R");
      current_statement__ = 66;
      context__.validate_dims("data initialization","nrep","int",
          context__.to_vec());
      nrep = std::numeric_limits<int>::min();
      
      current_statement__ = 66;
      nrep = context__.vals_i("nrep")[(1 - 1)];
      current_statement__ = 67;
      validate_non_negative_index("tl", "nMT", nMT);
      current_statement__ = 68;
      context__.validate_dims("data initialization","tl","double",
          context__.to_vec(nMT));
      tl = std::vector<double>(nMT, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 68;
      assign(tl, nil_index_list(), context__.vals_r("tl"),
        "assigning variable tl");
      current_statement__ = 69;
      validate_non_negative_index("logit_fn_rep", "NE", NE);
      current_statement__ = 70;
      context__.validate_dims("data initialization","logit_fn_rep","double",
          context__.to_vec(NE));
      logit_fn_rep = std::vector<double>(NE, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 70;
      assign(logit_fn_rep, nil_index_list(),
        context__.vals_r("logit_fn_rep"), "assigning variable logit_fn_rep");
      current_statement__ = 71;
      validate_non_negative_index("fn_se", "NE", NE);
      current_statement__ = 72;
      context__.validate_dims("data initialization","fn_se","double",
          context__.to_vec(NE));
      fn_se = std::vector<double>(NE, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 72;
      assign(fn_se, nil_index_list(), context__.vals_r("fn_se"),
        "assigning variable fn_se");
      current_statement__ = 73;
      validate_non_negative_index("Avg_Reads", "NF", NF);
      current_statement__ = 74;
      validate_non_negative_index("Avg_Reads", "nMT", nMT);
      current_statement__ = 75;
      context__.validate_dims("data initialization","Avg_Reads","double",
          context__.to_vec(NF, nMT));
      Avg_Reads = std::vector<std::vector<double>>(NF, std::vector<double>(nMT, std::numeric_limits<double>::quiet_NaN()));
      
      {
        std::vector<local_scalar_t__> Avg_Reads_flat__;
        current_statement__ = 75;
        assign(Avg_Reads_flat__, nil_index_list(),
          context__.vals_r("Avg_Reads"),
          "assigning variable Avg_Reads_flat__");
        current_statement__ = 75;
        pos__ = 1;
        current_statement__ = 75;
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          current_statement__ = 75;
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            current_statement__ = 75;
            assign(Avg_Reads,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              Avg_Reads_flat__[(pos__ - 1)], "assigning variable Avg_Reads");
            current_statement__ = 75;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 76;
      context__.validate_dims("data initialization","Chase","int",
          context__.to_vec());
      Chase = std::numeric_limits<int>::min();
      
      current_statement__ = 76;
      Chase = context__.vals_i("Chase")[(1 - 1)];
      current_statement__ = 76;
      current_statement__ = 76;
      check_greater_or_equal(function__, "Chase", Chase, 0);
      current_statement__ = 76;
      current_statement__ = 76;
      check_less_or_equal(function__, "Chase", Chase, 1);
      current_statement__ = 77;
      validate_non_negative_index("alpha", "NF", NF);
      current_statement__ = 78;
      validate_non_negative_index("alpha", "nMT", nMT);
      current_statement__ = 79;
      validate_non_negative_index("mu_fn", "nMT", nMT);
      current_statement__ = 80;
      validate_non_negative_index("log_sig_fn", "nMT", nMT);
      current_statement__ = 81;
      validate_non_negative_index("z_fn", "NF", NF);
      current_statement__ = 82;
      validate_non_negative_index("z_fn", "nMT", nMT);
      current_statement__ = 83;
      validate_non_negative_index("z_fn", "nrep", nrep);
      current_statement__ = 84;
      validate_non_negative_index("a", "nMT", nMT);
      current_statement__ = 85;
      validate_non_negative_index("b", "nMT", nMT);
      current_statement__ = 86;
      validate_non_negative_index("sd_rep", "nMT", nMT);
      current_statement__ = 87;
      validate_non_negative_index("z_rep", "NF", NF);
      current_statement__ = 88;
      validate_non_negative_index("z_rep", "nMT", nMT);
      current_statement__ = 89;
      validate_non_negative_index("mu_rep_logit_fn", "NF", NF);
      current_statement__ = 90;
      validate_non_negative_index("mu_rep_logit_fn", "nMT", nMT);
      current_statement__ = 91;
      validate_non_negative_index("mu_rep_logit_fn", "nrep", nrep);
      current_statement__ = 92;
      validate_non_negative_index("sig_fn", "nMT", nMT);
      current_statement__ = 93;
      validate_non_negative_index("sd_r_mu", "NF", NF);
      current_statement__ = 94;
      validate_non_negative_index("sd_r_mu", "nMT", nMT);
      current_statement__ = 95;
      validate_non_negative_index("kd", "NF", NF);
      current_statement__ = 96;
      validate_non_negative_index("kd", "nMT", nMT);
      current_statement__ = 97;
      validate_non_negative_index("L2FC_kd", "NF", NF);
      current_statement__ = 98;
      L2FC_kd_2dim__ = std::numeric_limits<int>::min();
      
      current_statement__ = 98;
      L2FC_kd_2dim__ = (nMT - 1);
      current_statement__ = 98;
      validate_non_negative_index("L2FC_kd", "nMT - 1", L2FC_kd_2dim__);
      current_statement__ = 99;
      validate_non_negative_index("log_kd", "NF", NF);
      current_statement__ = 100;
      validate_non_negative_index("log_kd", "nMT", nMT);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += NF * nMT;
      num_params_r__ += nMT;
      num_params_r__ += nMT;
      num_params_r__ += NF * nMT * nrep;
      num_params_r__ += nMT;
      num_params_r__ += nMT;
      num_params_r__ += nMT;
      num_params_r__ += NF * nMT;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_Hybrid_NSS_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> alpha;
      alpha = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(NF, Eigen::Matrix<local_scalar_t__, -1, 1>(nMT));
      stan::math::fill(alpha, DUMMY_VAR__);
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 1;
        assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nMT), "assigning variable alpha");}
      Eigen::Matrix<local_scalar_t__, -1, 1> mu_fn;
      mu_fn = Eigen::Matrix<local_scalar_t__, -1, 1>(nMT);
      stan::math::fill(mu_fn, DUMMY_VAR__);
      
      current_statement__ = 2;
      mu_fn = in__.vector(nMT);
      Eigen::Matrix<local_scalar_t__, -1, 1> log_sig_fn;
      log_sig_fn = Eigen::Matrix<local_scalar_t__, -1, 1>(nMT);
      stan::math::fill(log_sig_fn, DUMMY_VAR__);
      
      current_statement__ = 3;
      log_sig_fn = in__.vector(nMT);
      std::vector<std::vector<std::vector<local_scalar_t__>>> z_fn;
      z_fn = std::vector<std::vector<std::vector<local_scalar_t__>>>(NF, std::vector<std::vector<local_scalar_t__>>(nMT, std::vector<local_scalar_t__>(nrep, DUMMY_VAR__)));
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 4;
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          current_statement__ = 4;
          for (int sym3__ = 1; sym3__ <= nrep; ++sym3__) {
            current_statement__ = 4;
            assign(z_fn,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym3__), nil_index_list()))),
              in__.scalar(), "assigning variable z_fn");}}}
      Eigen::Matrix<local_scalar_t__, -1, 1> a;
      a = Eigen::Matrix<local_scalar_t__, -1, 1>(nMT);
      stan::math::fill(a, DUMMY_VAR__);
      
      current_statement__ = 5;
      a = in__.vector(nMT);
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 5;
        if (jacobian__) {
          current_statement__ = 5;
          assign(a, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(a[(sym1__ - 1)], 0, lp__),
            "assigning variable a");
        } else {
          current_statement__ = 5;
          assign(a, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(a[(sym1__ - 1)], 0),
            "assigning variable a");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> b;
      b = Eigen::Matrix<local_scalar_t__, -1, 1>(nMT);
      stan::math::fill(b, DUMMY_VAR__);
      
      current_statement__ = 6;
      b = in__.vector(nMT);
      Eigen::Matrix<local_scalar_t__, -1, 1> sd_rep;
      sd_rep = Eigen::Matrix<local_scalar_t__, -1, 1>(nMT);
      stan::math::fill(sd_rep, DUMMY_VAR__);
      
      current_statement__ = 7;
      sd_rep = in__.vector(nMT);
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 7;
        if (jacobian__) {
          current_statement__ = 7;
          assign(sd_rep, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sd_rep[(sym1__ - 1)], 0, lp__),
            "assigning variable sd_rep");
        } else {
          current_statement__ = 7;
          assign(sd_rep, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sd_rep[(sym1__ - 1)], 0),
            "assigning variable sd_rep");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> z_rep;
      z_rep = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(NF, Eigen::Matrix<local_scalar_t__, -1, 1>(nMT));
      stan::math::fill(z_rep, DUMMY_VAR__);
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 8;
        assign(z_rep, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nMT), "assigning variable z_rep");}
      std::vector<std::vector<std::vector<local_scalar_t__>>> mu_rep_logit_fn;
      mu_rep_logit_fn = std::vector<std::vector<std::vector<local_scalar_t__>>>(NF, std::vector<std::vector<local_scalar_t__>>(nMT, std::vector<local_scalar_t__>(nrep, DUMMY_VAR__)));
      
      Eigen::Matrix<local_scalar_t__, -1, 1> sig_fn;
      sig_fn = Eigen::Matrix<local_scalar_t__, -1, 1>(nMT);
      stan::math::fill(sig_fn, DUMMY_VAR__);
      
      current_statement__ = 10;
      assign(sig_fn, nil_index_list(), stan::math::exp(log_sig_fn),
        "assigning variable sig_fn");
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> sd_r_mu;
      sd_r_mu = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(NF, Eigen::Matrix<local_scalar_t__, -1, 1>(nMT));
      stan::math::fill(sd_r_mu, DUMMY_VAR__);
      
      current_statement__ = 19;
      for (int i = 1; i <= NF; ++i) {
        current_statement__ = 17;
        for (int j = 1; j <= nMT; ++j) {
          current_statement__ = 12;
          assign(sd_r_mu,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            stan::math::exp(
              (((-a[(j - 1)] * Avg_Reads[(i - 1)][(j - 1)]) + b[(j - 1)]) +
                (sd_rep[(j - 1)] * z_rep[(i - 1)][(j - 1)]))),
            "assigning variable sd_r_mu");
          current_statement__ = 15;
          for (int k = 1; k <= nrep; ++k) {
            current_statement__ = 13;
            assign(mu_rep_logit_fn,
              cons_list(index_uni(i),
                cons_list(index_uni(j),
                  cons_list(index_uni(k), nil_index_list()))),
              (alpha[(i - 1)][(j - 1)] +
                (z_fn[(i - 1)][(j - 1)][(k - 1)] * sd_r_mu[(i - 1)][(j - 1)])),
              "assigning variable mu_rep_logit_fn");}}}
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 10;
        current_statement__ = 10;
        check_greater_or_equal(function__, "sig_fn[sym1__]",
                               sig_fn[(sym1__ - 1)], 0);}
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 11;
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          current_statement__ = 11;
          current_statement__ = 11;
          check_greater_or_equal(function__, "sd_r_mu[sym1__, sym2__]",
                                 sd_r_mu[(sym1__ - 1)][(sym2__ - 1)], 0);}}
      {
        current_statement__ = 40;
        lp_accum__.add(normal_lpdf<propto__>(mu_fn, 0, 1.25));
        current_statement__ = 41;
        lp_accum__.add(normal_lpdf<propto__>(log_sig_fn, -1, 0.5));
        current_statement__ = 42;
        lp_accum__.add(normal_lpdf<propto__>(a, 0.3, 0.2));
        current_statement__ = 43;
        lp_accum__.add(normal_lpdf<propto__>(b, -1.5, 0.35));
        current_statement__ = 44;
        lp_accum__.add(lognormal_lpdf<propto__>(sd_rep, -2, 0.25));
        current_statement__ = 53;
        for (int i = 1; i <= NF; ++i) {
          current_statement__ = 45;
          lp_accum__.add(normal_lpdf<propto__>(z_rep[(i - 1)], 0, 1));
          current_statement__ = 51;
          for (int j = 1; j <= nMT; ++j) {
            current_statement__ = 46;
            lp_accum__.add(
              normal_lpdf<propto__>(alpha[(i - 1)][(j - 1)], mu_fn[(j - 1)],
                sig_fn[(j - 1)]));
            current_statement__ = 49;
            for (int k = 1; k <= nrep; ++k) {
              current_statement__ = 47;
              lp_accum__.add(
                normal_lpdf<propto__>(z_fn[(i - 1)][(j - 1)][(k - 1)], 0, 1));
            }}}
        current_statement__ = 56;
        for (int i = 1; i <= NE; ++i) {
          current_statement__ = 54;
          lp_accum__.add(
            normal_lpdf<propto__>(logit_fn_rep[(i - 1)],
              mu_rep_logit_fn[(FE[(i - 1)] - 1)][(MT[(i - 1)] - 1)][(R[
                                                                    (i - 1)]
                                                                    - 1)],
              fn_se[(i - 1)]));}
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_Hybrid_NSS_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      std::vector<Eigen::Matrix<double, -1, 1>> alpha;
      alpha = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 1;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 1;
        assign(alpha, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nMT), "assigning variable alpha");}
      Eigen::Matrix<double, -1, 1> mu_fn;
      mu_fn = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(mu_fn, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 2;
      mu_fn = in__.vector(nMT);
      Eigen::Matrix<double, -1, 1> log_sig_fn;
      log_sig_fn = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(log_sig_fn, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      log_sig_fn = in__.vector(nMT);
      std::vector<std::vector<std::vector<double>>> z_fn;
      z_fn = std::vector<std::vector<std::vector<double>>>(NF, std::vector<std::vector<double>>(nMT, std::vector<double>(nrep, std::numeric_limits<double>::quiet_NaN())));
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 4;
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          current_statement__ = 4;
          for (int sym3__ = 1; sym3__ <= nrep; ++sym3__) {
            current_statement__ = 4;
            assign(z_fn,
              cons_list(index_uni(sym1__),
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym3__), nil_index_list()))),
              in__.scalar(), "assigning variable z_fn");}}}
      Eigen::Matrix<double, -1, 1> a;
      a = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(a, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      a = in__.vector(nMT);
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 5;
        assign(a, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(a[(sym1__ - 1)], 0),
          "assigning variable a");}
      Eigen::Matrix<double, -1, 1> b;
      b = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(b, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      b = in__.vector(nMT);
      Eigen::Matrix<double, -1, 1> sd_rep;
      sd_rep = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(sd_rep, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      sd_rep = in__.vector(nMT);
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 7;
        assign(sd_rep, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sd_rep[(sym1__ - 1)], 0),
          "assigning variable sd_rep");}
      std::vector<Eigen::Matrix<double, -1, 1>> z_rep;
      z_rep = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(z_rep, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 8;
        assign(z_rep, cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nMT), "assigning variable z_rep");}
      std::vector<std::vector<std::vector<double>>> mu_rep_logit_fn;
      mu_rep_logit_fn = std::vector<std::vector<std::vector<double>>>(NF, std::vector<std::vector<double>>(nMT, std::vector<double>(nrep, std::numeric_limits<double>::quiet_NaN())));
      
      Eigen::Matrix<double, -1, 1> sig_fn;
      sig_fn = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(sig_fn, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> sd_r_mu;
      sd_r_mu = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(sd_r_mu, std::numeric_limits<double>::quiet_NaN());
      
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          vars__.emplace_back(alpha[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(mu_fn[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(log_sig_fn[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
            vars__.emplace_back(
              z_fn[(sym3__ - 1)][(sym2__ - 1)][(sym1__ - 1)]);}}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(a[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(b[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(sd_rep[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          vars__.emplace_back(z_rep[(sym2__ - 1)][(sym1__ - 1)]);}}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 10;
      assign(sig_fn, nil_index_list(), stan::math::exp(log_sig_fn),
        "assigning variable sig_fn");
      current_statement__ = 19;
      for (int i = 1; i <= NF; ++i) {
        current_statement__ = 17;
        for (int j = 1; j <= nMT; ++j) {
          current_statement__ = 12;
          assign(sd_r_mu,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            stan::math::exp(
              (((-a[(j - 1)] * Avg_Reads[(i - 1)][(j - 1)]) + b[(j - 1)]) +
                (sd_rep[(j - 1)] * z_rep[(i - 1)][(j - 1)]))),
            "assigning variable sd_r_mu");
          current_statement__ = 15;
          for (int k = 1; k <= nrep; ++k) {
            current_statement__ = 13;
            assign(mu_rep_logit_fn,
              cons_list(index_uni(i),
                cons_list(index_uni(j),
                  cons_list(index_uni(k), nil_index_list()))),
              (alpha[(i - 1)][(j - 1)] +
                (z_fn[(i - 1)][(j - 1)][(k - 1)] * sd_r_mu[(i - 1)][(j - 1)])),
              "assigning variable mu_rep_logit_fn");}}}
      current_statement__ = 10;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 10;
        current_statement__ = 10;
        check_greater_or_equal(function__, "sig_fn[sym1__]",
                               sig_fn[(sym1__ - 1)], 0);}
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        current_statement__ = 11;
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          current_statement__ = 11;
          current_statement__ = 11;
          check_greater_or_equal(function__, "sd_r_mu[sym1__, sym2__]",
                                 sd_r_mu[(sym1__ - 1)][(sym2__ - 1)], 0);}}
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
              vars__.emplace_back(
                mu_rep_logit_fn[(sym3__ - 1)][(sym2__ - 1)][(sym1__ - 1)]);}}
        }
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          vars__.emplace_back(sig_fn[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            vars__.emplace_back(sd_r_mu[(sym2__ - 1)][(sym1__ - 1)]);}}
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      std::vector<Eigen::Matrix<double, -1, 1>> kd;
      kd = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(kd, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> L2FC_kd;
      L2FC_kd = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(L2FC_kd_2dim__));
      stan::math::fill(L2FC_kd, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> log_kd;
      log_kd = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(log_kd, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 39;
      for (int i = 1; i <= NF; ++i) {
        current_statement__ = 30;
        for (int j = 1; j <= nMT; ++j) {
          current_statement__ = 27;
          if (logical_eq(Chase, 1)) {
            current_statement__ = 25;
            assign(kd,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              (-stan::math::log(inv_logit(alpha[(i - 1)][(j - 1)])) /
                tl[(j - 1)]), "assigning variable kd");
          } else {
            current_statement__ = 23;
            assign(kd,
              cons_list(index_uni(i),
                cons_list(index_uni(j), nil_index_list())),
              (-stan::math::log((1 - inv_logit(alpha[(i - 1)][(j - 1)]))) /
                tl[(j - 1)]), "assigning variable kd");
          }
          current_statement__ = 28;
          assign(log_kd,
            cons_list(index_uni(i),
              cons_list(index_uni(j), nil_index_list())),
            stan::math::log(kd[(i - 1)][(j - 1)]),
            "assigning variable log_kd");}
        current_statement__ = 37;
        for (int k = 1; k <= (nMT - 1); ++k) {
          current_statement__ = 35;
          if (logical_eq(Chase, 1)) {
            current_statement__ = 33;
            assign(L2FC_kd,
              cons_list(index_uni(i),
                cons_list(index_uni(k), nil_index_list())),
              (-alpha[(i - 1)][((k + 1) - 1)] + alpha[(i - 1)][(1 - 1)]),
              "assigning variable L2FC_kd");
          } else {
            current_statement__ = 31;
            assign(L2FC_kd,
              cons_list(index_uni(i),
                cons_list(index_uni(k), nil_index_list())),
              (alpha[(i - 1)][((k + 1) - 1)] - alpha[(i - 1)][(1 - 1)]),
              "assigning variable L2FC_kd");
          }}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          vars__.emplace_back(kd[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= L2FC_kd_2dim__; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          vars__.emplace_back(L2FC_kd[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          vars__.emplace_back(log_kd[(sym2__ - 1)][(sym1__ - 1)]);}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      std::vector<Eigen::Matrix<double, -1, 1>> alpha;
      alpha = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(alpha, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> alpha_flat__;
        current_statement__ = 1;
        assign(alpha_flat__, nil_index_list(), context__.vals_r("alpha"),
          "assigning variable alpha_flat__");
        current_statement__ = 1;
        pos__ = 1;
        current_statement__ = 1;
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          current_statement__ = 1;
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            current_statement__ = 1;
            assign(alpha,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              alpha_flat__[(pos__ - 1)], "assigning variable alpha");
            current_statement__ = 1;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> mu_fn;
      mu_fn = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(mu_fn, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> mu_fn_flat__;
        current_statement__ = 2;
        assign(mu_fn_flat__, nil_index_list(), context__.vals_r("mu_fn"),
          "assigning variable mu_fn_flat__");
        current_statement__ = 2;
        pos__ = 1;
        current_statement__ = 2;
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          current_statement__ = 2;
          assign(mu_fn, cons_list(index_uni(sym1__), nil_index_list()),
            mu_fn_flat__[(pos__ - 1)], "assigning variable mu_fn");
          current_statement__ = 2;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> log_sig_fn;
      log_sig_fn = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(log_sig_fn, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> log_sig_fn_flat__;
        current_statement__ = 3;
        assign(log_sig_fn_flat__, nil_index_list(),
          context__.vals_r("log_sig_fn"),
          "assigning variable log_sig_fn_flat__");
        current_statement__ = 3;
        pos__ = 1;
        current_statement__ = 3;
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          current_statement__ = 3;
          assign(log_sig_fn, cons_list(index_uni(sym1__), nil_index_list()),
            log_sig_fn_flat__[(pos__ - 1)], "assigning variable log_sig_fn");
          current_statement__ = 3;
          pos__ = (pos__ + 1);}
      }
      std::vector<std::vector<std::vector<double>>> z_fn;
      z_fn = std::vector<std::vector<std::vector<double>>>(NF, std::vector<std::vector<double>>(nMT, std::vector<double>(nrep, std::numeric_limits<double>::quiet_NaN())));
      
      {
        std::vector<local_scalar_t__> z_fn_flat__;
        current_statement__ = 4;
        assign(z_fn_flat__, nil_index_list(), context__.vals_r("z_fn"),
          "assigning variable z_fn_flat__");
        current_statement__ = 4;
        pos__ = 1;
        current_statement__ = 4;
        for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
          current_statement__ = 4;
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            current_statement__ = 4;
            for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
              current_statement__ = 4;
              assign(z_fn,
                cons_list(index_uni(sym3__),
                  cons_list(index_uni(sym2__),
                    cons_list(index_uni(sym1__), nil_index_list()))),
                z_fn_flat__[(pos__ - 1)], "assigning variable z_fn");
              current_statement__ = 4;
              pos__ = (pos__ + 1);}}}
      }
      Eigen::Matrix<double, -1, 1> a;
      a = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(a, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> a_flat__;
        current_statement__ = 5;
        assign(a_flat__, nil_index_list(), context__.vals_r("a"),
          "assigning variable a_flat__");
        current_statement__ = 5;
        pos__ = 1;
        current_statement__ = 5;
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          current_statement__ = 5;
          assign(a, cons_list(index_uni(sym1__), nil_index_list()),
            a_flat__[(pos__ - 1)], "assigning variable a");
          current_statement__ = 5;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> a_free__;
      a_free__ = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(a_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 5;
        assign(a_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(a[(sym1__ - 1)], 0),
          "assigning variable a_free__");}
      Eigen::Matrix<double, -1, 1> b;
      b = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(b, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> b_flat__;
        current_statement__ = 6;
        assign(b_flat__, nil_index_list(), context__.vals_r("b"),
          "assigning variable b_flat__");
        current_statement__ = 6;
        pos__ = 1;
        current_statement__ = 6;
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          current_statement__ = 6;
          assign(b, cons_list(index_uni(sym1__), nil_index_list()),
            b_flat__[(pos__ - 1)], "assigning variable b");
          current_statement__ = 6;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> sd_rep;
      sd_rep = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(sd_rep, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> sd_rep_flat__;
        current_statement__ = 7;
        assign(sd_rep_flat__, nil_index_list(), context__.vals_r("sd_rep"),
          "assigning variable sd_rep_flat__");
        current_statement__ = 7;
        pos__ = 1;
        current_statement__ = 7;
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          current_statement__ = 7;
          assign(sd_rep, cons_list(index_uni(sym1__), nil_index_list()),
            sd_rep_flat__[(pos__ - 1)], "assigning variable sd_rep");
          current_statement__ = 7;
          pos__ = (pos__ + 1);}
      }
      Eigen::Matrix<double, -1, 1> sd_rep_free__;
      sd_rep_free__ = Eigen::Matrix<double, -1, 1>(nMT);
      stan::math::fill(sd_rep_free__, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        current_statement__ = 7;
        assign(sd_rep_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sd_rep[(sym1__ - 1)], 0),
          "assigning variable sd_rep_free__");}
      std::vector<Eigen::Matrix<double, -1, 1>> z_rep;
      z_rep = std::vector<Eigen::Matrix<double, -1, 1>>(NF, Eigen::Matrix<double, -1, 1>(nMT));
      stan::math::fill(z_rep, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> z_rep_flat__;
        current_statement__ = 8;
        assign(z_rep_flat__, nil_index_list(), context__.vals_r("z_rep"),
          "assigning variable z_rep_flat__");
        current_statement__ = 8;
        pos__ = 1;
        current_statement__ = 8;
        for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
          current_statement__ = 8;
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            current_statement__ = 8;
            assign(z_rep,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              z_rep_flat__[(pos__ - 1)], "assigning variable z_rep");
            current_statement__ = 8;
            pos__ = (pos__ + 1);}}
      }
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          vars__.emplace_back(alpha[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(mu_fn[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(log_sig_fn[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          for (int sym3__ = 1; sym3__ <= nrep; ++sym3__) {
            vars__.emplace_back(
              z_fn[(sym1__ - 1)][(sym2__ - 1)][(sym3__ - 1)]);}}}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(a_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(b[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        vars__.emplace_back(sd_rep_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= NF; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          vars__.emplace_back(z_rep[(sym1__ - 1)][(sym2__ - 1)]);}}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("alpha");
    names__.emplace_back("mu_fn");
    names__.emplace_back("log_sig_fn");
    names__.emplace_back("z_fn");
    names__.emplace_back("a");
    names__.emplace_back("b");
    names__.emplace_back("sd_rep");
    names__.emplace_back("z_rep");
    names__.emplace_back("mu_rep_logit_fn");
    names__.emplace_back("sig_fn");
    names__.emplace_back("sd_r_mu");
    names__.emplace_back("kd");
    names__.emplace_back("L2FC_kd");
    names__.emplace_back("log_kd");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT),
                                             static_cast<size_t>(nrep)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT),
                                             static_cast<size_t>(nrep)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(L2FC_kd_2dim__)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(NF),
                                             static_cast<size_t>(nMT)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu_fn" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "log_sig_fn" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "z_fn" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "a" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "b" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sd_rep" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "z_rep" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "mu_rep_logit_fn" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sig_fn" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "sd_r_mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= L2FC_kd_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "L2FC_kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "log_kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "alpha" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "mu_fn" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "log_sig_fn" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
          {
            for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
              {
                param_names__.emplace_back(std::string() + "z_fn" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
              }}
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "a" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "b" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sd_rep" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "z_rep" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= nrep; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nMT; ++sym2__) {
            {
              for (int sym3__ = 1; sym3__ <= NF; ++sym3__) {
                {
                  param_names__.emplace_back(std::string() + "mu_rep_logit_fn" + '.' + std::to_string(sym3__) + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
                }}
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "sig_fn" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "sd_r_mu" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= L2FC_kd_2dim__; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "L2FC_kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nMT; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= NF; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "log_kd" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"parameters\"},{\"name\":\"mu_fn\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"log_sig_fn\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"z_fn\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"array\",\"length\":" << nrep << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"parameters\"},{\"name\":\"a\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"sd_rep\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"z_rep\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"parameters\"},{\"name\":\"mu_rep_logit_fn\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"array\",\"length\":" << nrep << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"transformed_parameters\"},{\"name\":\"sig_fn\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"transformed_parameters\"},{\"name\":\"sd_r_mu\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"transformed_parameters\"},{\"name\":\"kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"generated_quantities\"},{\"name\":\"L2FC_kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << L2FC_kd_2dim__ << "}},\"block\":\"generated_quantities\"},{\"name\":\"log_kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"alpha\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"parameters\"},{\"name\":\"mu_fn\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"log_sig_fn\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"z_fn\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"array\",\"length\":" << nrep << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"parameters\"},{\"name\":\"a\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"sd_rep\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"parameters\"},{\"name\":\"z_rep\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"parameters\"},{\"name\":\"mu_rep_logit_fn\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"array\",\"length\":" << nMT << ",\"element_type\":{\"name\":\"array\",\"length\":" << nrep << ",\"element_type\":{\"name\":\"real\"}}}},\"block\":\"transformed_parameters\"},{\"name\":\"sig_fn\",\"type\":{\"name\":\"vector\",\"length\":" << nMT << "},\"block\":\"transformed_parameters\"},{\"name\":\"sd_r_mu\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"transformed_parameters\"},{\"name\":\"kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"generated_quantities\"},{\"name\":\"L2FC_kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << L2FC_kd_2dim__ << "}},\"block\":\"generated_quantities\"},{\"name\":\"log_kd\",\"type\":{\"name\":\"array\",\"length\":" << NF << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nMT << "}},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_Hybrid_NSS_namespace::model_Hybrid_NSS;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_Hybrid_NSS_namespace::profiles__;
}
#endif
#endif
