% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_test_bbt_run_output.R
\name{create_test_bbt_run_output}
\alias{create_test_bbt_run_output}
\title{Get an example output of \code{\link{bbt_run}}
or \code{\link{bbt_run_from_model}}.}
\usage{
create_test_bbt_run_output()
}
\value{
the same results as \code{\link{bbt_run}}
  or \code{\link{bbt_run_from_model}}
}
\description{
This output is used in testing.
}
\examples{
 out <- create_test_bbt_run_output()

 library(testthat)
 expect_true("estimates" \%in\% names(out))
 expect_true("anthus_aco_trees" \%in\% names(out))
 expect_true("operators" \%in\% names(out))
 expect_true("output" \%in\% names(out))
 expect_true(is_phylo(out$anthus_aco_trees[[1]]))
 expect_true(length(out$anthus_aco_trees) == 2)

 expect_true("Sample" \%in\% names(out$estimates))
 expect_true("posterior" \%in\% names(out$estimates))
 expect_true("likelihood" \%in\% names(out$estimates))
 expect_true("prior" \%in\% names(out$estimates))
 expect_true("treeLikelihood" \%in\% names(out$estimates))
 expect_true("TreeHeight" \%in\% names(out$estimates))
 expect_true("YuleModel" \%in\% names(out$estimates))
 expect_true("birthRate" \%in\% names(out$estimates))

 expect_true("operator" \%in\% names(out$operators))
 expect_true("p" \%in\% names(out$operators))
 expect_true("accept" \%in\% names(out$operators))
 expect_true("reject" \%in\% names(out$operators))
 expect_true("acceptFC" \%in\% names(out$operators))
 expect_true("rejectFC" \%in\% names(out$operators))
 expect_true("rejectIv" \%in\% names(out$operators))
 expect_true("rejectOp" \%in\% names(out$operators))
}
\author{
Richèl J.C. Bilderbeek
}
