% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm_init_pars.R
\name{stsm_init_pars}
\alias{stsm_init_pars}
\title{Get initial parameter estimates for estimation}
\usage{
stsm_init_pars(
  y,
  freq,
  trend,
  cycle,
  decomp = "",
  seasons = NULL,
  prior = NULL,
  sig_level = 0.01,
  arma = c(p = NA, q = NA),
  exo = NULL,
  state_eqns = NULL,
  interpolate = NA,
  interpolate_method = NA
)
}
\arguments{
\item{y}{an object created from stsm_detect_frequency}

\item{freq}{Frequency of the data}

\item{trend}{Trend specification ("random-walk", "random-walk-drift", "double-random-walk", "random-walk2").}

\item{cycle}{The period for the longer-term cycle}

\item{decomp}{Decomposition model ("tend-cycle-seasonal", "trend-seasonal", "trend-cycle", "trend-noise")}

\item{seasons}{The seasonal lengths to split the seasonality into}

\item{prior}{A data table created by stsm_prior}

\item{sig_level}{Significance level for statistical tests}

\item{arma}{Named vector with values for p and q corresponding to the ARMA(p,q) specification if}

\item{exo}{Matrix of exogenous variables. Can be used to specify regression effects or other seasonal effects like holidays, etc.}

\item{state_eqns}{Character vector of equations to apply exo_state to the unobserved components. If left as the default, then all variables in
exo_state will be applied to all the unobserved components. The equations should look like:
"trend ~ var - 1", "drift ~ var - 1", "cycle ~ var - 1", "seasonal ~ var - 1".
If only some equations are specified, it will be assumed that the exogenous data will be applied to only those specified equations.}

\item{interpolate}{Character string giving frequency to interpolate to: i.e. "quarterly", "monthly", "weekly", "daily"
cycle is set to 'arma'. If NA, then will auto-select the order.}

\item{interpolate_method}{Character string giving the interpolation method:}
}
\value{
named vector containing the initial parameter estimates for estimation
}
\description{
Get initial parameter estimates for estimation
}
