% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AtomAbstractObject.R
\docType{class}
\name{AtomAbstractObject}
\alias{AtomAbstractObject}
\title{Atom feed class}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an Atom abstract Object
}
\description{
This class models an atom abstract object
}
\details{
AtomAbstractObject
}
\note{
abstract class used internally by \pkg{atom4R}
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{atom}
\section{Super class}{
\code{\link[atom4R:atom4RLogger]{atom4R::atom4RLogger}} -> \code{AtomAbstractObject}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{wrap}}{wrapping XML element}

\item{\code{element}}{element}

\item{\code{namespace}}{namespace}

\item{\code{defaults}}{defaults}

\item{\code{attrs}}{attrs}

\item{\code{printAttrs}}{attrs to print}

\item{\code{parentAttrs}}{parent attrs}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-AtomAbstractObject-new}{\code{AtomAbstractObject$new()}}
\item \href{#method-AtomAbstractObject-setIsDocument}{\code{AtomAbstractObject$setIsDocument()}}
\item \href{#method-AtomAbstractObject-isDocument}{\code{AtomAbstractObject$isDocument()}}
\item \href{#method-AtomAbstractObject-getRootElement}{\code{AtomAbstractObject$getRootElement()}}
\item \href{#method-AtomAbstractObject-getNamespace}{\code{AtomAbstractObject$getNamespace()}}
\item \href{#method-AtomAbstractObject-createElement}{\code{AtomAbstractObject$createElement()}}
\item \href{#method-AtomAbstractObject-addListElement}{\code{AtomAbstractObject$addListElement()}}
\item \href{#method-AtomAbstractObject-delListElement}{\code{AtomAbstractObject$delListElement()}}
\item \href{#method-AtomAbstractObject-contains}{\code{AtomAbstractObject$contains()}}
\item \href{#method-AtomAbstractObject-print}{\code{AtomAbstractObject$print()}}
\item \href{#method-AtomAbstractObject-decode}{\code{AtomAbstractObject$decode()}}
\item \href{#method-AtomAbstractObject-encode}{\code{AtomAbstractObject$encode()}}
\item \href{#method-AtomAbstractObject-validate}{\code{AtomAbstractObject$validate()}}
\item \href{#method-AtomAbstractObject-save}{\code{AtomAbstractObject$save()}}
\item \href{#method-AtomAbstractObject-isFieldInheritedFrom}{\code{AtomAbstractObject$isFieldInheritedFrom()}}
\item \href{#method-AtomAbstractObject-getClassName}{\code{AtomAbstractObject$getClassName()}}
\item \href{#method-AtomAbstractObject-getClass}{\code{AtomAbstractObject$getClass()}}
\item \href{#method-AtomAbstractObject-getNamespaceDefinition}{\code{AtomAbstractObject$getNamespaceDefinition()}}
\item \href{#method-AtomAbstractObject-getXmlElement}{\code{AtomAbstractObject$getXmlElement()}}
\item \href{#method-AtomAbstractObject-clone}{\code{AtomAbstractObject$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="ERROR"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-ERROR'><code>atom4R::atom4RLogger$ERROR()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="INFO"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-INFO'><code>atom4R::atom4RLogger$INFO()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="WARN"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-WARN'><code>atom4R::atom4RLogger$WARN()</code></a></span></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="logger"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-logger'><code>atom4R::atom4RLogger$logger()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-new"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-new}{}}}
\subsection{Method \code{new()}}{
Initializes an object of class \link{AtomAbstractObject}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$new(
  xml = NULL,
  element = NULL,
  namespace = NULL,
  attrs = list(),
  defaults = list(),
  wrap = TRUE,
  logger = "INFO"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class}}

\item{\code{element}}{element}

\item{\code{namespace}}{namespace}

\item{\code{attrs}}{attrs}

\item{\code{defaults}}{defaults}

\item{\code{wrap}}{wrap}

\item{\code{logger}}{logger type}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-setIsDocument"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-setIsDocument}{}}}
\subsection{Method \code{setIsDocument()}}{
Set if object is a document or not
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$setIsDocument(isDocument)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{isDocument}}{object of class \code{logical}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-isDocument"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-isDocument}{}}}
\subsection{Method \code{isDocument()}}{
Informs if the object is a document
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$isDocument()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object of class \code{logical}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-getRootElement"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-getRootElement}{}}}
\subsection{Method \code{getRootElement()}}{
Get root XML element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$getRootElement()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-getNamespace"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-getNamespace}{}}}
\subsection{Method \code{getNamespace()}}{
Get XML namespace
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$getNamespace()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-createElement"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-createElement}{}}}
\subsection{Method \code{createElement()}}{
Creates an element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$createElement(element, type = "text")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{element}}{element}

\item{\code{type}}{type. Default is "text"}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the typed element
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-addListElement"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-addListElement}{}}}
\subsection{Method \code{addListElement()}}{
Add a metadata element to an element list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$addListElement(field, metadataElement)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{field}

\item{\code{metadataElement}}{metadata element to add}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if added, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-delListElement"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-delListElement}{}}}
\subsection{Method \code{delListElement()}}{
Deletes a metadata element from an element list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$delListElement(field, metadataElement)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{field}

\item{\code{metadataElement}}{metadata element to add}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if deleted, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-contains"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-contains}{}}}
\subsection{Method \code{contains()}}{
Indicates if an element list contains or not an element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$contains(field, metadataElement)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{field}

\item{\code{metadataElement}}{metadata element to add}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if contained, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-print"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-print}{}}}
\subsection{Method \code{print()}}{
Prints the element
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$print(..., depth = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{any parameter to pass to print method}

\item{\code{depth}}{printing depth}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-decode"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-decode}{}}}
\subsection{Method \code{decode()}}{
Decodes the object from an \pkg{XML} representation
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$decode(xml)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class} from \pkg{XML}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-encode"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-encode}{}}}
\subsection{Method \code{encode()}}{
Encodes the object as XML
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$encode(
  addNS = TRUE,
  validate = TRUE,
  strict = FALSE,
  encoding = "UTF-8"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{addNS}}{whether namespace has to be added. Default is \code{TRUE}}

\item{\code{validate}}{whether validation has to be done vs. XML schemas. Default is \code{TRUE}}

\item{\code{strict}}{whether strict validation has to be operated (raise an error if invalid). Default is \code{FALSE}}

\item{\code{encoding}}{encoding. Default is "UTF-8"}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-validate"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-validate}{}}}
\subsection{Method \code{validate()}}{
Validates the object / XML vs. XML schemas
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$validate(xml = NULL, strict = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{object of class \link{XMLInternalNode-class} from \pkg{XML}}

\item{\code{strict}}{strict validation or not}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{TRUE} if valid, \code{FALSE} otherwise
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-save"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-save}{}}}
\subsection{Method \code{save()}}{
Saves the object as XML file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$save(file, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{file name}

\item{\code{...}}{any parameter to pass to \code{encode()} method}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-isFieldInheritedFrom"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-isFieldInheritedFrom}{}}}
\subsection{Method \code{isFieldInheritedFrom()}}{
Indicates the class from which field is inherited
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$isFieldInheritedFrom(field)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{field}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
an object of class \link{R6Class}, or \code{NULL}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-getClassName"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-getClassName}{}}}
\subsection{Method \code{getClassName()}}{
Get class name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$getClassName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-getClass"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-getClass}{}}}
\subsection{Method \code{getClass()}}{
Get class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$getClass()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object of class \link{R6Class}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-getNamespaceDefinition"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-getNamespaceDefinition}{}}}
\subsection{Method \code{getNamespaceDefinition()}}{
Get namespace definition
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$getNamespaceDefinition(recursive = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{recursive}}{recursive}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a named \code{list} of the XML namespaces
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-getXmlElement"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-getXmlElement}{}}}
\subsection{Method \code{getXmlElement()}}{
Get XML element name
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$getXmlElement()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
object of class \code{character}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-AtomAbstractObject-clone"></a>}}
\if{latex}{\out{\hypertarget{method-AtomAbstractObject-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{AtomAbstractObject$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
