context("Combinations")

test_that("Combinations - ncombinations", {
    L = c(LETTERS, letters)
    expect_equal(ncombinations(10, 3), 120)
    expect_equal(ncombinations(x = L[1:10], k = 3), 120)
    expect_error(ncombinations(40, 15), "integer overflow")
    expect_error(ncombinations(x = L[1:40], k = 15), "integer overflow")
    expect_equal(ncombinations(40, 15, bigz = TRUE), gmp::as.bigz("40225345056"))
    expect_equal(ncombinations(10, 0), 1)
    expect_equal(ncombinations(10, 11), 0)
    expect_error(ncombinations(10, -1), "expect non-negative integer")
    expect_error(ncombinations(10, 1.5), "expect non-negative integer")

    expect_equal(ncombinations(0, 0), 1)
    expect_equal(ncombinations(0, 1), 0)
})

test_that("Combinations - combinations", {
    comb <- combinations(10, 3)
    expect_equal(nrow(comb), 120)
    expect_equal(ncol(comb), 3)
    expect_equal(comb[1, ], 1:3)
    expect_equal(comb[120, ], 8:10)

    comb <- combinations(10, 3, type = "r")
    expect_equal(nrow(comb), 120)
    expect_equal(ncol(comb), 3)
    expect_equal(comb[1, ], 1:3)
    expect_equal(comb[120, ], 8:10)

    comb <- combinations(10, 3, type = "c")
    expect_equal(ncol(comb), 120)
    expect_equal(nrow(comb), 3)
    expect_equal(comb[, 1], 1:3)
    expect_equal(comb[, 120], 8:10)

    comb <- combinations(10, 3, type = "l")
    expect_equal(length(comb), 120)
    expect_equal(comb[[1]], 1:3)
    expect_equal(comb[[120]], 8:10)

    comb <- combinations(x = LETTERS[1:10], k = 3)
    expect_equal(nrow(comb), 120)
    expect_equal(ncol(comb), 3)
    expect_equal(comb[1, ], LETTERS[1:3])
    expect_equal(comb[120, ], LETTERS[8:10])

    expect_error(combinations(40, 15), "too many results")
    expect_error(combinations(10, -1), "expect non-negative integer")
    expect_error(combinations(10, 1.5), "expect non-negative integer")
    expect_equal(dim(combinations(10, 0)), c(1, 0))
    expect_equal(dim(combinations(10, 11)), c(0, 11))
    expect_equal(dim(combinations(0, 0)), c(1, 0))
    expect_equal(dim(combinations(0, 1)), c(0, 1))
})

test_that("Combinations - icombinations", {
    icomb <- icombinations(10, 3)
    comb <- combinations(10, 3)
    expect_equal(icomb$collect(), comb)
    expect_equal(icomb$getnext(), 1:3)
    expect_equal(icomb$getnext(), c(1, 2, 4))
    icomb$getnext(110)
    expect_equal(nrow(icomb$getnext(10)), 8)
    expect_equal(icomb$getnext(), NULL)

    comb <- combinations(10, 3, type = "r")
    expect_equal(icomb$collect(type = "r"), comb)
    expect_equal(icomb$getnext(type = "r"), t(1:3))
    expect_equal(icomb$getnext(type = "r"), t(c(1, 2, 4)))
    icomb$getnext(110, type = "r")
    expect_equal(nrow(icomb$getnext(10, type = "r")), 8)
    expect_equal(icomb$getnext(type = "r"), NULL)

    comb <- combinations(10, 3, type = "c")
    expect_equal(icomb$collect(type = "c"), comb)
    expect_equal(icomb$getnext(type = "c"), t(t(1:3)))
    expect_equal(icomb$getnext(type = "c"), t(t(c(1, 2, 4))))
    icomb$getnext(110, type = "c")
    expect_equal(ncol(icomb$getnext(10, type = "c")), 8)
    expect_equal(icomb$getnext(type = "c"), NULL)

    comb <- combinations(10, 3, type = "l")
    expect_equal(icomb$collect(type = "l"), comb)
    expect_equal(icomb$getnext(type = "l"), list(1:3))
    expect_equal(icomb$getnext(type = "l"), list(c(1, 2, 4)))
    icomb$getnext(110, type = "l")
    expect_equal(length(icomb$getnext(10, type = "l")), 8)
    expect_equal(icomb$getnext(type = "l"), NULL)

    icomb <- icombinations(10, 0)
    expect_equal(dim(icomb$collect()), c(1, 0))
    expect_equal(length(icomb$getnext()), 0)
    expect_equal(icomb$getnext(), NULL)
    icomb <- icombinations(10, 11)
    expect_equal(icomb$collect(), NULL)
    expect_equal(icomb$getnext(), NULL)
    expect_error(icombinations(10, -1), "expect non-negative integer")
    expect_error(icombinations(10, 1.5), "expect non-negative integer")
})
