% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutations.R
\name{npermutations}
\alias{npermutations}
\title{Number of permutations}
\usage{
npermutations(n, k = n, x = NULL, freq = NULL, replace = FALSE,
  bigz = FALSE)
}
\arguments{
\item{n}{an integer. If \code{freq} is not NULL, \code{n} would be set as \code{sum(freq)},
otherwise if \code{x} is not NULL, \code{n} would be set as \code{length(x)}.}

\item{k}{an integer}

\item{x}{an optional vector indicating item labels}

\item{freq}{an integer vector of item repeat frequencies}

\item{replace}{an logical to draw items with replacement}

\item{bigz}{an logical to indicate using \link[gmp:bigz]{gmp::bigz}}
}
\description{
Number of permutations
}
\examples{
npermutations(7)
npermutations(x = LETTERS[1:5])
npermutations(5, 2)
npermutations(x = LETTERS, k = 5)

# integer overflow
\dontrun{npermutations(14, 10)}
npermutations(14, 10, bigz = TRUE)

# number of permutations of `c("a", "b", "b")`
# they are `c("a", "b")`, `c("b", "b")` and `c("b", "b")`
npermutations(freq = c(1, 2), k = 2)

# zero sized partitions
npermutations(0)
npermutations(5, 0)
npermutations(5, 6)
npermutations(0, 1)
npermutations(0, 0)
}
\seealso{
\link{permutations} for generating all permutations and \link{ipermutations} for iterating permutations
}
