% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/mutators.R
\docType{methods}
\name{mutators}
\alias{mutators}
\alias{get}
\alias{set}
\alias{has_groups}
\alias{has_groups-method}
\alias{get_groups}
\alias{get_groups-method}
\alias{set_groups<-}
\alias{set_groups-method}
\alias{get_samples}
\alias{get_samples-method}
\alias{set_samples<-}
\alias{set_samples-method}
\alias{has_dates}
\alias{has_dates-method}
\alias{get_dates}
\alias{get_dates-method}
\alias{set_dates<-}
\alias{set_dates-method}
\alias{has_terminus}
\alias{has_terminus-method}
\alias{get_terminus}
\alias{get_terminus-method}
\alias{set_terminus<-}
\alias{set_terminus-method}
\alias{get_tpq}
\alias{get_tpq-method}
\alias{set_tpq<-}
\alias{set_tpq-method}
\alias{get_taq}
\alias{get_taq-method}
\alias{set_taq<-}
\alias{set_taq-method}
\alias{get_totals}
\alias{get_totals-method}
\alias{set_totals<-}
\alias{set_totals-method}
\alias{has_groups,AbundanceMatrix-method}
\alias{get_groups,AbundanceMatrix-method}
\alias{get_samples,AbundanceMatrix-method}
\alias{has_dates,AbundanceMatrix-method}
\alias{get_dates,AbundanceMatrix-method}
\alias{has_terminus,AbundanceMatrix-method}
\alias{get_terminus,AbundanceMatrix-method}
\alias{get_tpq,AbundanceMatrix-method}
\alias{get_taq,AbundanceMatrix-method}
\alias{get_totals,AbundanceMatrix-method}
\alias{get_totals,OccurrenceMatrix-method}
\alias{set_groups<-,AbundanceMatrix-method}
\alias{set_groups,AbundanceMatrix-method}
\alias{set_samples<-,AbundanceMatrix-method}
\alias{set_samples,AbundanceMatrix-method}
\alias{set_dates<-,AbundanceMatrix,NULL-method}
\alias{set_dates,AbundanceMatrix,NULL-method}
\alias{set_dates<-,AbundanceMatrix,numeric-method}
\alias{set_dates,AbundanceMatrix,numeric-method}
\alias{set_terminus<-,AbundanceMatrix,NULL-method}
\alias{set_terminus,AbundanceMatrix,NULL-method}
\alias{set_terminus<-,AbundanceMatrix,list-method}
\alias{set_terminus,AbundanceMatrix,list-method}
\alias{set_tpq<-,AbundanceMatrix,NULL-method}
\alias{set_tpq,AbundanceMatrix,NULL-method}
\alias{set_tpq<-,AbundanceMatrix,numeric-method}
\alias{set_tpq,AbundanceMatrix,numeric-method}
\alias{set_taq<-,AbundanceMatrix,NULL-method}
\alias{set_taq,AbundanceMatrix,NULL-method}
\alias{set_taq<-,AbundanceMatrix,numeric-method}
\alias{set_taq,AbundanceMatrix,numeric-method}
\alias{set_totals<-,AbundanceMatrix-method}
\alias{set_totals,AbundanceMatrix-method}
\title{Get or Set Parts of an Object}
\usage{
has_groups(x)

get_groups(x)

set_groups(x) <- value

get_samples(x)

set_samples(x) <- value

has_dates(x)

get_dates(x)

set_dates(x) <- value

has_terminus(x)

get_terminus(x)

set_terminus(x) <- value

get_tpq(x)

set_tpq(x) <- value

get_taq(x)

set_taq(x) <- value

get_totals(x)

set_totals(x) <- value

\S4method{has_groups}{AbundanceMatrix}(x)

\S4method{get_groups}{AbundanceMatrix}(x)

\S4method{get_samples}{AbundanceMatrix}(x)

\S4method{has_dates}{AbundanceMatrix}(x)

\S4method{get_dates}{AbundanceMatrix}(x)

\S4method{has_terminus}{AbundanceMatrix}(x)

\S4method{get_terminus}{AbundanceMatrix}(x)

\S4method{get_tpq}{AbundanceMatrix}(x)

\S4method{get_taq}{AbundanceMatrix}(x)

\S4method{get_totals}{AbundanceMatrix}(x)

\S4method{get_totals}{OccurrenceMatrix}(x)

\S4method{set_groups}{AbundanceMatrix}(x) <- value

\S4method{set_samples}{AbundanceMatrix}(x) <- value

\S4method{set_dates}{AbundanceMatrix,`NULL`}(x) <- value

\S4method{set_dates}{AbundanceMatrix,numeric}(x) <- value

\S4method{set_terminus}{AbundanceMatrix,`NULL`}(x) <- value

\S4method{set_terminus}{AbundanceMatrix,list}(x) <- value

\S4method{set_tpq}{AbundanceMatrix,`NULL`}(x) <- value

\S4method{set_tpq}{AbundanceMatrix,numeric}(x) <- value

\S4method{set_taq}{AbundanceMatrix,`NULL`}(x) <- value

\S4method{set_taq}{AbundanceMatrix,numeric}(x) <- value

\S4method{set_totals}{AbundanceMatrix}(x) <- value
}
\arguments{
\item{x}{An object from which to get or set element(s) (typically an
\code{\linkS4class{AbundanceMatrix}} object).}

\item{value}{A possible value for the element(s) of \code{x}.}
}
\value{
\itemize{
\item \verb{set_*()} returns an object of the same sort as \code{x} with the new values
assigned.
\item \verb{get_*()} returns the part of \code{x}.
\item \verb{has_*()} returns a \code{\link{logical}} scalar.
}
}
\description{
Getters and setters to retrieve or set parts of an object.
}
\details{
\describe{
\item{\code{get_samples(x)} and \code{get_samples(x) <- value}}{Get or set
the sample names of \code{x}.}
\item{\code{get_groups(x)} and \code{set_groups(x) <- value}}{Get or set
the groups of \code{x}.}
\item{\code{get_dates(x)} and \code{set_dates(x) <- value}}{Get or set the dates of
\code{x}.}
\item{\code{get_terminus(x)} and \code{set_terminus(x) <- value}}{Get or set
the chronology of \code{x}. \code{value} must be a \code{\link{list}} with components \code{tpq}
(TPQ - \emph{terminus post quem}) and \code{taq} (TAQ - \emph{terminus ante quem}).}
\item{\code{get_tpq(x)} and \code{set_tpq(x) <- value},
\code{get_taq(x)} and \code{set_taq(x) <- value}}{Get or set the TPQ/TAQ of \code{x}.}
}
}
\section{Chronology}{

The way chronological information is handled is somewhat opinionated.
Sub-annual precision is overkill/meaningless in most situations: dates are
assumed to be expressed in years CE and are stored as integers (values are
coerced with \code{as.integer()} and hence truncated towards zero).
}

\examples{
## Create a data.frame
X <- matrix(data = sample(0:10, 50, TRUE), nrow = 10, ncol = 5)
Y <- as.data.frame(X)

## Coerce to a count matrix
Z <- as_count(Y)

## Set/get groups
set_samples(Z) <- rep(c("a", "b", "c", "d", "e"), each = 2)
get_samples(Z)

## Set/get groups
set_groups(Z) <- rep(c("A", "B"), each = 5)
get_groups(Z)

## Get/get TPQ/TAQ
chrono <- list(
  tpq = sample(1301:1400, 10, replace = TRUE),
  taq = sample(1451:1500, 10, replace = TRUE)
)
set_terminus(Z) <- chrono
get_terminus(Z)

## Collection of features
as_features(Z)

## Summarize data
summary(Z)
}
\seealso{
Other mutators: 
\code{\link{subset}()},
\code{\link{summary}()}
}
\author{
N. Frerebeau
}
\concept{mutators}
