% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\name{unalign}
\alias{unalign}
\title{Deconstruct an alignment.}
\usage{
unalign(x, gap = "-")
}
\arguments{
\item{x}{a matrix of aligned sequences. Accepted modes are "character"
and "raw" (for "DNAbin" and "AAbin" objects).}

\item{gap}{the character used to represent gaps in the alignment matrix.
Ignored for \code{"DNAbin"} or \code{"AAbin"} objects. Defaults to "-"
otherwise.}
}
\value{
a list of sequences of the same mode and class as the input alignment
  (ie "DNAbin", "AAbin", or plain ASCII characters).
}
\description{
\code{unalign} deconstructs an alignment to a list of sequences.
}
\details{
\code{unalign} works in the opposite way to \code{\link{align}},
  reducing a matrix of aligned sequences to a list of sequences without gaps.
  "DNAbin" and "AAbin" matrix objects are supported (and recommended for
  biological sequence data)
}
\examples{
## Convert the woodmouse alignment in the ape package to a list of
## unaligned sequences
library(ape)
data(woodmouse)
x <- unalign(woodmouse)
}
\seealso{
\code{\link{align}}.
}
\author{
Shaun Wilkinson
}
