% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diversity.R
\name{plotDiversityCurve}
\alias{plotDiversityCurve}
\title{Plot the results of rarefyDiversity}
\usage{
plotDiversityCurve(data, colors = NULL, main_title = "Diversity",
  legend_title = "Group", log_q = TRUE, log_d = TRUE, xlim = NULL,
  ylim = NULL, annotate = c("none", "depth"), silent = FALSE, ...)
}
\arguments{
\item{data}{\link{DiversityCurve} object returned by 
\link{rarefyDiversity}.}

\item{colors}{named character vector whose names are values in the 
\code{group} column of the \code{data} slot of \code{data},
and whose values are colors to assign to those group names.}

\item{main_title}{string specifying the plot title.}

\item{legend_title}{string specifying the legend title.}

\item{log_q}{if \code{TRUE} then plot \eqn{q} on a log scale;
if \code{FALSE} plot on a linear scale.}

\item{log_d}{if \code{TRUE} then plot the diversity scores \eqn{D} 
on a log scale; if \code{FALSE} plot on a linear scale.}

\item{xlim}{numeric vector of two values specifying the 
\code{c(lower, upper)} x-axis limits.}

\item{ylim}{numeric vector of two values specifying the 
\code{c(lower, upper)} y-axis limits.}

\item{annotate}{string defining whether to added values to the group labels 
of the legend. When \code{"none"} (default) is specified no
annotations are added. Specifying (\code{"depth"}) adds 
sequence counts to the labels.}

\item{silent}{if \code{TRUE} do not draw the plot and just return the ggplot2 
object; if \code{FALSE} draw the plot.}

\item{...}{additional arguments to pass to ggplot2::theme.}
}
\value{
A \code{ggplot} object defining the plot.
}
\description{
\code{plotDiversityCurve} plots a \code{DiversityCurve} object.
}
\examples{
# All groups pass default minimum sampling threshold of 10 sequences
div <- rarefyDiversity(ExampleDb, "SAMPLE", step_q=0.1, max_q=10, nboot=100)
plotDiversityCurve(div, legend_title="Sample")

}
\seealso{
See \link{rarefyDiversity} for generating \link{DiversityCurve}
          objects for input. Plotting is performed with \link{ggplot}.
}

