#' Statistics for populations of bears
#' 
#' Computed f_4(W,X;Y,Z) statistics for different populations of bears.
#' 
#' @format A data frame with 18 rows and 6 variables:
#' \describe{
#'  \item{W}{The W population}
#'  \item{X}{The X population}
#'  \item{Y}{The Y population}
#'  \item{Z}{The Z population}
#'  \item{D}{The D (f_4(W,X;Y,Z)) statistics}
#'  \item{Z.value}{The blocked jacknife Z values}
#' }
#' @source \url{http://onlinelibrary.wiley.com/doi/10.1111/mec.13038/abstract}
"bears"

#' Admixture graphs of 2 leaves and 0 admixture events compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 1 row and 9 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_2_0"

#' Admixture graphs of 3 leaves and 0 admixture events compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 1 row and 25 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_3_0"

#' Admixture graphs of 3 leaves and 1 admixture event compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 3 rows and 49 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_3_1"

#' Admixture graphs of 4 leaves and 0 admixture events compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 3 rows and 49 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_4_0"

#' Admixture graphs of 4 leaves and 1 admixture event compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 30 rows and 81 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_4_1"

#' Admixture graphs of 4 leaves and 2 admixture events compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 486 rows and 121 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_4_2"

#' Admixture graphs of 5 leaves and 0 admixture events compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 15 rows and 81 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_5_0"

#' Admixture graphs of 5 leaves and 1 admixture event compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 315 rows and 121 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_5_1"

#' Admixture graphs of 5 leaves and 2 admixture events compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 7710 rows and 169 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_5_2"

#' Admixture graphs of 6 leaves and 0 admixture events compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 105 rows and 121 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_6_0"

#' Admixture graphs of 6 leaves and 1 admixture event compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 3780 rows and 169 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_6_1"

#' Admixture graphs of 6 leaves and 2 admixture events compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 131400 rows and 225 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_6_2"

#' Admixture graphs of 7 leaves and 0 admixture events compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 945 rows and 169 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_7_0"

#' Admixture graphs of 7 leaves and 1 admixture event compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 51975 rows and 225 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_7_1"

#' Admixture graphs of 8 leaves and 0 admixture events compressed into vectors
#' 
#' Use \code{\link{vector_to_graph}} on the \code{n}:th row to access the \code{n}:th graph
#' as an \code{\link{agraph}} object.
#' 
#' @format A data frame with 10395 rows and 225 variables.
#' @source Calculated using \code{\link{all_graphs}} and \code{\link{graph_to_vector}}.
"graphs_8_0"
