% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_dataset}
\alias{get_dataset}
\title{Retrieve a Dataset from the \code{admiraldev_environment} environment}
\usage{
get_dataset(name)
}
\arguments{
\item{name}{The name of the dataset to retrieve}
}
\value{
A \code{data.frame}
}
\description{
Retrieve a Dataset from the \code{admiraldev_environment} environment
}
\details{
Sometimes, developers may want to provide information to users which does not fit into a
warning or error message. For example, if the input dataset of a function contains unexpected
records, these can be stored in a separate dataset, which users can access to investigate
the issue.

To achieve this, R has a data structure known as an 'environment'. These environment objects
are created at build time, but can be populated with values after the package has been loaded
and update those values over the course of an R session.

As so, the establishment of \code{admiraldev_environment} allows us to create dynamic data/objects
based on user-inputs that need modification. The purpose of \code{get_dataset} is to
retrieve the datasets contained inside \code{admiraldev_environment}.

Currently we only support two datasets inside our \code{admiraldev_environment} object:
\itemize{
\item \code{one_to_many}
\item \code{many_to_one}
}
}
\seealso{
Brings something to you!?!: 
\code{\link{get_constant_vars}()},
\code{\link{get_duplicates}()},
\code{\link{get_source_vars}()}
}
\concept{get}
\keyword{get}
