% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_vars_dt_dtm_utils.R
\name{get_imputation_targets}
\alias{get_imputation_targets}
\title{Get Imputation Targets}
\usage{
get_imputation_targets(partial, date_imputation = NULL, time_imputation = NULL)
}
\arguments{
\item{partial}{A list of partial date/time components.

\describe{
\item{Default value}{none}
}}

\item{date_imputation}{The value to impute the day/month when a datepart is
missing.

A character value is expected, either as a
\itemize{
\item format with month and day specified as \code{"mm-dd"}: e.g. \code{"06-15"} for the 15th
of June,
\item or as a keyword: \code{"first"}, \code{"mid"}, \code{"last"} to impute to the first/mid/last
day/month.
}

\describe{
\item{Default value}{none}
}}

\item{time_imputation}{The value to impute the time when a timepart is
missing.

A character value is expected, either as a
\itemize{
\item format with hour, min and sec specified as \code{"hh:mm:ss"}: e.g. \code{"00:00:00"}
for the start of the day,
\item or as a keyword: \code{"first"},\code{"last"} to impute to the start/end of a day.
}

\describe{
\item{Default value}{none}
}}
}
\value{
A list of imputation targets for date and (if applicable) time components.
}
\description{
Determines the imputation targets for date (see \code{get_imputation_target_date()} and time
(see \code{get_imputation_target_time()}) components.
}
\examples{
# Get imputation targets for a date with 'first' date imputation
partial_date <- list(year = "2020", month = "03", day = NA_character_)
target_first_date <- admiral:::get_imputation_targets(partial_date,
  date_imputation = "first",
  time_imputation = NULL
)
print(target_first_date)

# Get imputation targets for a datetime with 'first' date and time imputation
partial_datetime <- list(
  year = "2020",
  month = "03",
  day = NA_character_,
  hour = "12",
  minute = NA_character_,
  second = NA_character_
)
target_first_datetime <- admiral:::get_imputation_targets(partial_datetime,
  date_imputation = "first",
  time_imputation = "first"
)
print(target_first_datetime)

# Get imputation targets for a datetime with 'last' date and time imputation
target_last_datetime <- admiral:::get_imputation_targets(partial_datetime,
  date_imputation = "last",
  time_imputation = "last"
)
print(target_last_datetime)

# Get imputation targets for a date with custom date imputation '06-15'
target_custom_date <- admiral:::get_imputation_targets(partial_date,
  date_imputation = "06-15",
  time_imputation = NULL
)
print(target_custom_date)

# Get imputation targets for a datetime with custom time imputation '12:34:56'
target_custom_time <- admiral:::get_imputation_targets(partial_datetime,
  date_imputation = "first",
  time_imputation = "12:34:56"
)
print(target_custom_time)

}
\keyword{internal}
