% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_computed.R
\name{derive_param_computed}
\alias{derive_param_computed}
\title{Adds a Parameter Computed from the Analysis Value of Other Parameters}
\usage{
derive_param_computed(
  dataset = NULL,
  dataset_add = NULL,
  by_vars,
  parameters,
  set_values_to,
  filter = NULL,
  constant_by_vars = NULL,
  constant_parameters = NULL,
  keep_nas = FALSE
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} argument are expected to be in the dataset.
\code{PARAMCD} is expected as well.

The variable specified by \code{by_vars} and \code{PARAMCD} must be a unique key of
the input dataset after restricting it by the filter condition (\code{filter}
parameter) and to the parameters specified by \code{parameters}.

\describe{
\item{Permitted values}{a dataset, i.e., a \code{data.frame} or tibble}
\item{Default value}{\code{NULL}}
}}

\item{dataset_add}{Additional dataset

The variables specified by the \code{by_vars} parameter are expected.

The variable specified by \code{by_vars} and \code{PARAMCD} must be a unique key of
the additional dataset after restricting it to the parameters specified by
\code{parameters}.

If the argument is specified, the observations of the additional dataset
are considered in addition to the observations from the input dataset
(\code{dataset} restricted by \code{filter}).

\describe{
\item{Permitted values}{a dataset, i.e., a \code{data.frame} or tibble}
\item{Default value}{\code{NULL}}
}}

\item{by_vars}{Grouping variables

For each group defined by \code{by_vars} an observation is added to the output
dataset. Only variables specified in \code{by_vars} will be populated
in the newly created records.

\describe{
\item{Permitted values}{list of variables created by \code{exprs()}, e.g., \code{exprs(USUBJID, VISIT)}}
\item{Default value}{none}
}}

\item{parameters}{Required parameter codes

It is expected that all parameter codes (\code{PARAMCD}) which are required to
derive the new parameter are specified for this parameter or the
\code{constant_parameters} parameter.

If observations should be considered which do not have a parameter code,
e.g., if an SDTM dataset is used, temporary parameter codes can be derived
by specifying a list of expressions. The name of the element defines the
temporary parameter code and the expression the condition for selecting the
records. For example \code{parameters = exprs(HGHT = VSTESTCD == "HEIGHT")}
selects the observations with \code{VSTESTCD == "HEIGHT"} from the input data
(\code{dataset} and \code{dataset_add}), sets \code{PARAMCD = "HGHT"} for these
observations, and adds them to the observations to consider.

Unnamed elements in the list of expressions are considered as parameter
codes. For example, \code{parameters = exprs(WEIGHT, HGHT = VSTESTCD == "HEIGHT")} uses the parameter code \code{"WEIGHT"} and creates a temporary
parameter code \code{"HGHT"}.

\describe{
\item{Permitted values}{A character vector of \code{PARAMCD} values or a list of expressions}
\item{Default value}{none}
}}

\item{set_values_to}{Variables to be set

The specified variables are set to the specified values for the new
observations. The values of variables of the parameters specified by
\code{parameters} can be accessed using \verb{<variable name>.<parameter code>}. For
example

\if{html}{\out{<div class="sourceCode">}}\preformatted{exprs(
  AVAL = (AVAL.SYSBP + 2 * AVAL.DIABP) / 3,
  PARAMCD = "MAP"
)
}\if{html}{\out{</div>}}

defines the analysis value and parameter code for the new parameter.

Variable names in the expression must not contain more than one dot.

Note that \code{dplyr} helper functions such as \code{dplyr::starts_with()} should
be avoided unless the list of variable-value pairs is clearly
specified in a statement via the \code{set_values_to} argument.

\describe{
\item{Permitted values}{list of named expressions created by a formula using \code{exprs()}, e.g., \code{exprs(AVALC = VSSTRESC, AVAL = yn_to_numeric(AVALC))}}
\item{Default value}{none}
}}

\item{filter}{Filter condition

The specified condition is applied to the input dataset before deriving the
new parameter, i.e., only observations fulfilling the condition are taken
into account.

\describe{
\item{Permitted values}{an unquoted condition, e.g., \code{AVISIT == "BASELINE"}}
\item{Default value}{\code{NULL}}
}}

\item{constant_by_vars}{By variables for constant parameters

The constant parameters (parameters that are measured only once) are merged
to the other parameters using the specified variables. (Refer to Example 2)

\describe{
\item{Permitted values}{list of variables created by \code{exprs()}, e.g., \code{exprs(USUBJID, VISIT)}}
\item{Default value}{\code{NULL}}
}}

\item{constant_parameters}{Required constant parameter codes

It is expected that all the parameter codes (\code{PARAMCD}) which are required
to derive the new parameter and are measured only once are specified here.
For example if BMI should be derived and height is measured only once while
weight is measured at each visit. Height could be specified in the
\code{constant_parameters} parameter. (Refer to Example 2)

If observations should be considered which do not have a parameter code,
e.g., if an SDTM dataset is used, temporary parameter codes can be derived
by specifying a list of expressions. The name of the element defines the
temporary parameter code and the expression the condition for selecting the
records. For example \code{constant_parameters = exprs(HGHT = VSTESTCD == "HEIGHT")} selects the observations with \code{VSTESTCD == "HEIGHT"} from the
input data (\code{dataset} and \code{dataset_add}), sets \code{PARAMCD = "HGHT"} for these
observations, and adds them to the observations to consider.

Unnamed elements in the list of expressions are considered as parameter
codes. For example, \code{constant_parameters = exprs(WEIGHT, HGHT = VSTESTCD == "HEIGHT")} uses the parameter code \code{"WEIGHT"} and creates a temporary
parameter code \code{"HGHT"}.

\describe{
\item{Permitted values}{A character vector of \code{PARAMCD} values or a list of expressions}
\item{Default value}{\code{NULL}}
}}

\item{keep_nas}{Keep observations with \code{NA}s

If the argument is set to \code{TRUE}, observations are added even if some of
the values contributing to the computed value are \code{NA} (see Example 1b).

If the argument is set to a list of variables, observations are added even
if some of specified variables are \code{NA} (see Example 1c).

\describe{
\item{Permitted values}{\code{TRUE}, \code{FALSE}, or a list of variables created by
\code{exprs()} e.g. \code{exprs(ADTF, ATMF)}}
\item{Default value}{\code{FALSE}}
}}
}
\value{
The input dataset with the new parameter added. Note, a variable will only
be populated in the new parameter rows if it is specified in \code{by_vars}.
}
\description{
Adds a parameter computed from the analysis value of other parameters. It is
expected that the analysis value of the new parameter is defined by an
expression using the analysis values of other parameters, such as addition/sum,
subtraction/difference, multiplication/product, division/ratio,
exponentiation/logarithm, or by formula.
\if{html}{\out{<br/>}}\if{html}{\out{<br/>}}
For example mean arterial pressure (MAP) can be derived from systolic (SYSBP)
and diastolic blood pressure (DIABP) with the formula
\deqn{MAP = \frac{SYSBP + 2 DIABP}{3}}{MAP = (SYSBP + 2 DIABP) / 3}
}
\details{
For each group (with respect to the variables specified for the
\code{by_vars} parameter) an observation is added to the output dataset if the
filtered input dataset (\code{dataset}) or the additional dataset
(\code{dataset_add}) contains exactly one observation for each parameter code
specified for \code{parameters} and all contributing values like \code{AVAL.SYSBP}
are not \code{NA}. The \code{keep_nas} can be used to specify variables for which
\code{NA}s are acceptable. See also Example 1b and 1c.

For the new observations the variables specified for \code{set_values_to} are
set to the provided values. The values of the other variables of the input
dataset are set to \code{NA}.
}
\seealso{
BDS-Findings Functions for adding Parameters/Records: 
\code{\link{default_qtc_paramcd}()},
\code{\link{derive_expected_records}()},
\code{\link{derive_extreme_event}()},
\code{\link{derive_extreme_records}()},
\code{\link{derive_locf_records}()},
\code{\link{derive_param_bmi}()},
\code{\link{derive_param_bsa}()},
\code{\link{derive_param_doseint}()},
\code{\link{derive_param_exist_flag}()},
\code{\link{derive_param_exposure}()},
\code{\link{derive_param_framingham}()},
\code{\link{derive_param_map}()},
\code{\link{derive_param_qtc}()},
\code{\link{derive_param_rr}()},
\code{\link{derive_param_wbc_abs}()},
\code{\link{derive_summary_records}()}
}
\concept{der_prm_bds_findings}
\keyword{der_prm_bds_findings}
\section{Examples}{
\subsection{Example 1 - Data setup}{

Examples 1a, 1b, and 1c use the following \code{ADVS} data.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ADVS <- tribble(
  ~USUBJID,      ~PARAMCD, ~PARAM,                            ~AVAL, ~VISIT,
  "01-701-1015", "DIABP",  "Diastolic Blood Pressure (mmHg)",    51, "BASELINE",
  "01-701-1015", "DIABP",  "Diastolic Blood Pressure (mmHg)",    50, "WEEK 2",
  "01-701-1015", "SYSBP",  "Systolic Blood Pressure (mmHg)",    121, "BASELINE",
  "01-701-1015", "SYSBP",  "Systolic Blood Pressure (mmHg)",    121, "WEEK 2",
  "01-701-1028", "DIABP",  "Diastolic Blood Pressure (mmHg)",    79, "BASELINE",
  "01-701-1028", "DIABP",  "Diastolic Blood Pressure (mmHg)",    80, "WEEK 2",
  "01-701-1028", "SYSBP",  "Systolic Blood Pressure (mmHg)",    130, "BASELINE",
  "01-701-1028", "SYSBP",  "Systolic Blood Pressure (mmHg)",     NA, "WEEK 2"
) \%>\%
  mutate(
    AVALU = "mmHg",
    ADT = case_when(
      VISIT == "BASELINE" ~ as.Date("2024-01-10"),
      VISIT == "WEEK 2" ~ as.Date("2024-01-24")
    ),
    ADTF = NA_character_
  )}\if{html}{\out{</div>}}}
\subsection{Example 1a - Adding a parameter computed from a formula
(\code{parameters}, \code{set_values_to})}{

Derive mean arterial pressure (MAP) from systolic (SYSBP)
and diastolic blood pressure (DIABP).
\itemize{
\item Here, for each \code{USUBJID} and \code{VISIT} group (specified in \code{by_vars}),
an observation is added to the output dataset when the filtered
input dataset (\code{dataset}) contains exactly one observation for
each parameter code specified for \code{parameters} and all contributing
values (e.g., \code{AVAL.SYSBP} and \code{AVAL.DIABP}) are not \code{NA}.
Indeed, patient \code{01-701-1028} does not get a \code{"WEEK 2"}-derived record
as \code{AVAL} is \code{NA} for their \code{"WEEK 2"} systolic blood pressure.
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{derive_param_computed(
  ADVS,
  by_vars = exprs(USUBJID, VISIT),
  parameters = c("SYSBP", "DIABP"),
  set_values_to = exprs(
    AVAL = (AVAL.SYSBP + 2 * AVAL.DIABP) / 3,
    PARAMCD = "MAP",
    PARAM = "Mean Arterial Pressure (mmHg)",
    AVALU = "mmHg",
    ADT = ADT.SYSBP
  )
) \%>\%
select(-PARAM)
#> # A tibble: 11 × 7
#>    USUBJID     PARAMCD  AVAL VISIT    AVALU ADT        ADTF 
#>    <chr>       <chr>   <dbl> <chr>    <chr> <date>     <chr>
#>  1 01-701-1015 DIABP    51   BASELINE mmHg  2024-01-10 <NA> 
#>  2 01-701-1015 DIABP    50   WEEK 2   mmHg  2024-01-24 <NA> 
#>  3 01-701-1015 SYSBP   121   BASELINE mmHg  2024-01-10 <NA> 
#>  4 01-701-1015 SYSBP   121   WEEK 2   mmHg  2024-01-24 <NA> 
#>  5 01-701-1028 DIABP    79   BASELINE mmHg  2024-01-10 <NA> 
#>  6 01-701-1028 DIABP    80   WEEK 2   mmHg  2024-01-24 <NA> 
#>  7 01-701-1028 SYSBP   130   BASELINE mmHg  2024-01-10 <NA> 
#>  8 01-701-1028 SYSBP    NA   WEEK 2   mmHg  2024-01-24 <NA> 
#>  9 01-701-1015 MAP      74.3 BASELINE mmHg  2024-01-10 <NA> 
#> 10 01-701-1015 MAP      73.7 WEEK 2   mmHg  2024-01-24 <NA> 
#> 11 01-701-1028 MAP      96   BASELINE mmHg  2024-01-10 <NA> }\if{html}{\out{</div>}}}
\subsection{Example 1b - Keeping missing values for any source
variables (\code{keep_nas = TRUE})}{

Use option \code{keep_nas = TRUE} to derive MAP in the case where
some/all values of a variable used in the computation are missing.
\itemize{
\item Note that observations will be added here even if some of the values contributing
to the computed values are \code{NA}. In particular, patient \code{01-701-1028}
does get a \code{"WEEK 2"}-derived record as compared to Example 1a, but
with \code{AVAL = NA}.
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{derive_param_computed(
  ADVS,
  by_vars = exprs(USUBJID, VISIT),
  parameters = c("SYSBP", "DIABP"),
  set_values_to = exprs(
    AVAL = (AVAL.SYSBP + 2 * AVAL.DIABP) / 3,
    PARAMCD = "MAP",
    PARAM = "Mean Arterial Pressure (mmHg)",
    AVALU = "mmHg",
    ADT = ADT.SYSBP,
    ADTF = ADTF.SYSBP
  ),
  keep_nas = TRUE
)\%>\%
select(-PARAM)
#> # A tibble: 12 × 7
#>    USUBJID     PARAMCD  AVAL VISIT    AVALU ADT        ADTF 
#>    <chr>       <chr>   <dbl> <chr>    <chr> <date>     <chr>
#>  1 01-701-1015 DIABP    51   BASELINE mmHg  2024-01-10 <NA> 
#>  2 01-701-1015 DIABP    50   WEEK 2   mmHg  2024-01-24 <NA> 
#>  3 01-701-1015 SYSBP   121   BASELINE mmHg  2024-01-10 <NA> 
#>  4 01-701-1015 SYSBP   121   WEEK 2   mmHg  2024-01-24 <NA> 
#>  5 01-701-1028 DIABP    79   BASELINE mmHg  2024-01-10 <NA> 
#>  6 01-701-1028 DIABP    80   WEEK 2   mmHg  2024-01-24 <NA> 
#>  7 01-701-1028 SYSBP   130   BASELINE mmHg  2024-01-10 <NA> 
#>  8 01-701-1028 SYSBP    NA   WEEK 2   mmHg  2024-01-24 <NA> 
#>  9 01-701-1015 MAP      74.3 BASELINE mmHg  2024-01-10 <NA> 
#> 10 01-701-1015 MAP      73.7 WEEK 2   mmHg  2024-01-24 <NA> 
#> 11 01-701-1028 MAP      96   BASELINE mmHg  2024-01-10 <NA> 
#> 12 01-701-1028 MAP      NA   WEEK 2   mmHg  2024-01-24 <NA> }\if{html}{\out{</div>}}}
\subsection{Example 1c - Keeping missing values for some source
variables (\code{keep_nas = exprs()})}{

Use option \code{keep_nas = exprs(ADTF)} to derive MAP in the case where
some/all values of a variable used in the computation are
missing but keeping \code{NA} values of \code{ADTF}.
\itemize{
\item This is subtly distinct from Examples 1a and 1b. In 1a, we do not
get new derived records if any of the source records have a value
of \code{NA} for a variable that is included in \code{set_values_to}.
In 1b, we do the opposite and allow the creation of new records
regardless of how many \code{NA}s we encounter in the source variables.
\item Here, we want to disregard \code{NA} values but only from the variables
that are specified via \code{keep_na_values}.
\item This is important because we have added \code{ADTF} in \code{set_values_to},
but all values of this variable are \code{NA}. As such, in order to
get any derived records at all, but continue not getting one
when \code{AVAL} is \code{NA} in any of the source records,
(see patient \code{"01-701-1028"} again), we specify \code{keep_nas = exprs(ADTF)}.
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{derive_param_computed(
  ADVS,
  by_vars = exprs(USUBJID, VISIT),
  parameters = c("SYSBP", "DIABP"),
  set_values_to = exprs(
    AVAL = (AVAL.SYSBP + 2 * AVAL.DIABP) / 3,
    PARAMCD = "MAP",
    PARAM = "Mean Arterial Pressure (mmHg)",
    AVALU = "mmHg",
    ADT = ADT.SYSBP,
    ADTF = ADTF.SYSBP
  ),
  keep_nas = exprs(ADTF)
)
#> # A tibble: 11 × 8
#>    USUBJID     PARAMCD PARAM                   AVAL VISIT AVALU ADT        ADTF 
#>    <chr>       <chr>   <chr>                  <dbl> <chr> <chr> <date>     <chr>
#>  1 01-701-1015 DIABP   Diastolic Blood Press…  51   BASE… mmHg  2024-01-10 <NA> 
#>  2 01-701-1015 DIABP   Diastolic Blood Press…  50   WEEK… mmHg  2024-01-24 <NA> 
#>  3 01-701-1015 SYSBP   Systolic Blood Pressu… 121   BASE… mmHg  2024-01-10 <NA> 
#>  4 01-701-1015 SYSBP   Systolic Blood Pressu… 121   WEEK… mmHg  2024-01-24 <NA> 
#>  5 01-701-1028 DIABP   Diastolic Blood Press…  79   BASE… mmHg  2024-01-10 <NA> 
#>  6 01-701-1028 DIABP   Diastolic Blood Press…  80   WEEK… mmHg  2024-01-24 <NA> 
#>  7 01-701-1028 SYSBP   Systolic Blood Pressu… 130   BASE… mmHg  2024-01-10 <NA> 
#>  8 01-701-1028 SYSBP   Systolic Blood Pressu…  NA   WEEK… mmHg  2024-01-24 <NA> 
#>  9 01-701-1015 MAP     Mean Arterial Pressur…  74.3 BASE… mmHg  2024-01-10 <NA> 
#> 10 01-701-1015 MAP     Mean Arterial Pressur…  73.7 WEEK… mmHg  2024-01-24 <NA> 
#> 11 01-701-1028 MAP     Mean Arterial Pressur…  96   BASE… mmHg  2024-01-10 <NA> }\if{html}{\out{</div>}}}
\subsection{Example 2 - Derivations using parameters measured only once
(\code{constant_parameters} and \code{constant_by_vars})}{

Derive BMI where \code{HEIGHT} is measured only once.
\itemize{
\item In the above examples, for each parameter specified in the
\code{parameters} argument, we expect one record per by group, where the by
group is specified in \code{by_vars}. However, if a parameter is only
measured once, it can be specified in \code{constant_parameters} instead.
\item A modified by group still needs to be provided for the constant
parameters. This can be done via \code{constant_by_vars}.
\item See the example below, where weight is measured for each patient
at each visit (\code{by_vars = exprs(USUBJID, VISIT)}), while height
is measured for each patient only at the first visit
(\code{constant_parameters = "HEIGHT"}, \verb{constant_by_vars = exprs(USUBJID})).
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ADVS <- tribble(
  ~USUBJID,      ~PARAMCD, ~PARAM,        ~AVAL, ~AVALU, ~VISIT,
  "01-701-1015", "HEIGHT", "Height (cm)", 147.0, "cm",   "SCREENING",
  "01-701-1015", "WEIGHT", "Weight (kg)",  54.0, "kg",   "SCREENING",
  "01-701-1015", "WEIGHT", "Weight (kg)",  54.4, "kg",   "BASELINE",
  "01-701-1015", "WEIGHT", "Weight (kg)",  53.1, "kg",   "WEEK 2",
  "01-701-1028", "HEIGHT", "Height (cm)", 163.0, "cm",   "SCREENING",
  "01-701-1028", "WEIGHT", "Weight (kg)",  78.5, "kg",   "SCREENING",
  "01-701-1028", "WEIGHT", "Weight (kg)",  80.3, "kg",   "BASELINE",
  "01-701-1028", "WEIGHT", "Weight (kg)",  80.7, "kg",   "WEEK 2"
)

derive_param_computed(
  ADVS,
  by_vars = exprs(USUBJID, VISIT),
  parameters = "WEIGHT",
  set_values_to = exprs(
    AVAL = AVAL.WEIGHT / (AVAL.HEIGHT / 100)^2,
    PARAMCD = "BMI",
    PARAM = "Body Mass Index (kg/m^2)",
    AVALU = "kg/m^2"
  ),
  constant_parameters = c("HEIGHT"),
  constant_by_vars = exprs(USUBJID)
)
#> # A tibble: 14 × 6
#>    USUBJID     PARAMCD PARAM                     AVAL AVALU  VISIT    
#>    <chr>       <chr>   <chr>                    <dbl> <chr>  <chr>    
#>  1 01-701-1015 HEIGHT  Height (cm)              147   cm     SCREENING
#>  2 01-701-1015 WEIGHT  Weight (kg)               54   kg     SCREENING
#>  3 01-701-1015 WEIGHT  Weight (kg)               54.4 kg     BASELINE 
#>  4 01-701-1015 WEIGHT  Weight (kg)               53.1 kg     WEEK 2   
#>  5 01-701-1028 HEIGHT  Height (cm)              163   cm     SCREENING
#>  6 01-701-1028 WEIGHT  Weight (kg)               78.5 kg     SCREENING
#>  7 01-701-1028 WEIGHT  Weight (kg)               80.3 kg     BASELINE 
#>  8 01-701-1028 WEIGHT  Weight (kg)               80.7 kg     WEEK 2   
#>  9 01-701-1015 BMI     Body Mass Index (kg/m^2)  25.0 kg/m^2 SCREENING
#> 10 01-701-1015 BMI     Body Mass Index (kg/m^2)  25.2 kg/m^2 BASELINE 
#> 11 01-701-1015 BMI     Body Mass Index (kg/m^2)  24.6 kg/m^2 WEEK 2   
#> 12 01-701-1028 BMI     Body Mass Index (kg/m^2)  29.5 kg/m^2 SCREENING
#> 13 01-701-1028 BMI     Body Mass Index (kg/m^2)  30.2 kg/m^2 BASELINE 
#> 14 01-701-1028 BMI     Body Mass Index (kg/m^2)  30.4 kg/m^2 WEEK 2   }\if{html}{\out{</div>}}}
\subsection{Example 3 - Derivations including data from an additional
dataset (\code{dataset_add}) and non-\code{AVAL} variables}{

Use data from an additional dataset and other variables than \code{AVAL}.
\itemize{
\item In this example, the dataset specified via \code{dataset_add} (e.g., \code{QS})
is an SDTM dataset. There is no parameter code in the dataset.
\item The \code{parameters} argument is therefore used to specify a list of
expressions to derive temporary parameter codes.
\item Then, \code{set_values_to} is used to specify the values for the new
observations of each variable, and variable-value pairs from both
datasets are referenced via \code{exprs()}.
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{QS <- tribble(
  ~USUBJID, ~AVISIT,   ~QSTESTCD, ~QSORRES, ~QSSTRESN,
  "1",      "WEEK 2",  "CHSF112", NA,               1,
  "1",      "WEEK 2",  "CHSF113", "Yes",           NA,
  "1",      "WEEK 2",  "CHSF114", NA,               1,
  "1",      "WEEK 4",  "CHSF112", NA,               2,
  "1",      "WEEK 4",  "CHSF113", "No",            NA,
  "1",      "WEEK 4",  "CHSF114", NA,               1
)

ADCHSF <- tribble(
  ~USUBJID, ~AVISIT,  ~PARAMCD, ~QSSTRESN, ~AVAL,
  "1",      "WEEK 2", "CHSF12", 1,             6,
  "1",      "WEEK 2", "CHSF14", 1,             6,
  "1",      "WEEK 4", "CHSF12", 2,            12,
  "1",      "WEEK 4", "CHSF14", 1,             6
) \%>\%
  mutate(QSORRES = NA_character_)

derive_param_computed(
  ADCHSF,
  dataset_add = QS,
  by_vars = exprs(USUBJID, AVISIT),
  parameters = exprs(CHSF12, CHSF13 = QSTESTCD \%in\% c("CHSF113"), CHSF14),
  set_values_to = exprs(
    AVAL = case_when(
      QSORRES.CHSF13 == "Not applicable" ~ 0,
      QSORRES.CHSF13 == "Yes" ~ 38,
      QSORRES.CHSF13 == "No" ~ if_else(
        QSSTRESN.CHSF12 > QSSTRESN.CHSF14,
        25,
        0
      )
    ),
    PARAMCD = "CHSF13"
  )
)
#> # A tibble: 6 × 6
#>   USUBJID AVISIT PARAMCD QSSTRESN  AVAL QSORRES
#>   <chr>   <chr>  <chr>      <dbl> <dbl> <chr>  
#> 1 1       WEEK 2 CHSF12         1     6 <NA>   
#> 2 1       WEEK 2 CHSF14         1     6 <NA>   
#> 3 1       WEEK 4 CHSF12         2    12 <NA>   
#> 4 1       WEEK 4 CHSF14         1     6 <NA>   
#> 5 1       WEEK 2 CHSF13        NA    38 <NA>   
#> 6 1       WEEK 4 CHSF13        NA    25 <NA>   }\if{html}{\out{</div>}}}
\subsection{Example 4 - Computing more than one variable}{

Specify more than one variable-value pair via \code{set_values_to}.
\itemize{
\item In this example, the values of \code{AVALC}, \code{ADTM}, \code{ADTF}, \code{PARAMCD},
and \code{PARAM} are determined via distinctly defined analysis values
and parameter codes.
\item This is different from Example 3 as more than one variable is
derived.
}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ADLB_TBILIALK <- tribble(
  ~USUBJID, ~PARAMCD, ~AVALC, ~ADTM,        ~ADTF,
  "1",      "ALK2",   "Y",    "2021-05-13", NA_character_,
  "1",      "TBILI2", "Y",    "2021-06-30", "D",
  "2",      "ALK2",   "Y",    "2021-12-31", "M",
  "2",      "TBILI2", "N",    "2021-11-11", NA_character_,
  "3",      "ALK2",   "N",    "2021-04-03", NA_character_,
  "3",      "TBILI2", "N",    "2021-04-04", NA_character_
) \%>\%
  mutate(ADTM = ymd(ADTM))

derive_param_computed(
  dataset_add = ADLB_TBILIALK,
  by_vars = exprs(USUBJID),
  parameters = c("ALK2", "TBILI2"),
  set_values_to = exprs(
    AVALC = if_else(AVALC.TBILI2 == "Y" & AVALC.ALK2 == "Y", "Y", "N"),
    ADTM = pmax(ADTM.TBILI2, ADTM.ALK2),
    ADTF = if_else(ADTM == ADTM.TBILI2, ADTF.TBILI2, ADTF.ALK2),
    PARAMCD = "TB2AK2",
    PARAM = "TBILI > 2 times ULN and ALKPH <= 2 times ULN"
  ),
  keep_nas = TRUE
)
#> # A tibble: 3 × 6
#>   USUBJID AVALC ADTM       ADTF  PARAMCD PARAM                                  
#>   <chr>   <chr> <date>     <chr> <chr>   <chr>                                  
#> 1 1       Y     2021-06-30 D     TB2AK2  TBILI > 2 times ULN and ALKPH <= 2 tim…
#> 2 2       N     2021-12-31 M     TB2AK2  TBILI > 2 times ULN and ALKPH <= 2 tim…
#> 3 3       N     2021-04-04 <NA>  TB2AK2  TBILI > 2 times ULN and ALKPH <= 2 tim…}\if{html}{\out{</div>}}}}

