% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printFunctions.R
\name{hierCredTweedie-class}
\alias{hierCredTweedie-class}
\alias{print.hierCredTweedie}
\alias{summary.hierCredTweedie}
\alias{fitted.hierCredTweedie}
\title{Class "hierCredTweedie" of fitted random effects models estimated with Ohlsson's GLMC algorithm}
\usage{
\method{print}{hierCredTweedie}(x, ...)

\method{summary}{hierCredTweedie}(object, ...)

\method{fitted}{hierCredTweedie}(object, ...)
}
\arguments{
\item{x}{an object of class \code{\link{hierCredTweedie}}}

\item{...}{currently ignored.}

\item{object}{an object of class \code{\link{hierCredTweedie}}}
}
\value{
The function \code{\link{hierCredGLM}} returns an object of class \code{hierCredGLM}, which has the following slots:

\item{call}{the matched call}

\item{HierarchicalResults}{results of the hierarchical credibility model.}

\item{fitGLM}{the results from fitting the GLM part.}

\item{iter}{total number of iterations.}

\item{Converged}{logical indicating whether the algorithm converged.}

\item{LevelsCov}{object that summarizes the unique levels of each of the contract-specific covariates.}

\item{fitted.values}{the fitted mean values, resulting from the model fit.}

\item{prior.weights}{the weights (exposure) initially supplied.}

\item{y}{if requested, the response vector. Default is \code{TRUE}.}
}
\description{
Class "hierCredTweedie" of fitted random effects models estimated with Ohlsson's GLMC algorithm
}
\section{{S3 methods}}{

\describe{
 \item{\code{print}:}{Prints the \code{call}, the estimated variance parameters, the unique number of categories
  of the hierarchical MLF and the output of the GLM part. The \code{...} argument is currently ignored. Returns an
  invisible copy of the original object.}
 \item{\code{summary}:}{In addition to the output of the \code{print.hierCredTweedie} function, the \code{summary} function
  also prints the random effect estimates and a summary of the GLM (see \code{\link{summary.glm}}). Returns an
   invisible copy of the original object.}
   \item{\code{fitted}:}{Returns the fitted values.}
}
}

\seealso{
\code{\link{hierCredTweedie}}
}
