% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultipleTSsimulation.R
\name{MultipleSimulationVLtimeseries}
\alias{MultipleSimulationVLtimeseries}
\title{MultipleSimulationVLtimeseries}
\usage{
MultipleSimulationVLtimeseries(
  n = 200,
  lag = 5,
  YstFixInx = 111,
  YfnFixInx = 150,
  XpointFixInx = 100,
  arimaFlag = TRUE
)
}
\arguments{
\item{n}{is length of time series.}

\item{lag}{is a time lag between \code{X} and \code{Y} s.t. \code{Y[t]} is approximately \code{X[t-lag]}.}

\item{YstFixInx}{is the starting point of variable lag part.}

\item{YfnFixInx}{is the end point of variable lag part.}

\item{XpointFixInx}{is a point in X s.t. \code{ Y[YstFixInx:YfnFixInx]= X[XpointFixInx] }.}

\item{arimaFlag}{is ARMA model flag. If it is true, then \code{X} is generated by ARMA model.
If it is false, then  \code{X} is generated by sampling of the standard normal distribution.}
}
\value{
This function returns a list of time series \code{TS}.
}
\description{
MultipleSimulationVLtimeseries is a support function for generating a set of time series \code{TS[,1],...TS[,10]}.
TS[,1],TS[,2],TS[,3] are causes \code{X} time series that are generated independently.
The rest of time series are \code{Y} time series that are effects of some causes TS[,1],TS[,2],TS[,3].
TS[,1] causes TS[,4],TS[,7],TS[,8], and TS[,10].
TS[,2] causes TS[,5],TS[,7],TS[,9], and TS[,10].
TS[,3] causes TS[,6],TS[,8],TS[,9], and TS[,10].
}
\examples{
# Generate simulation data
TS <- MultipleSimulationVLtimeseries()

}
