% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_toil_Mut.R
\name{vis_toil_Mut_cancer}
\alias{vis_toil_Mut_cancer}
\title{Visualize molecular profile difference between mutation and wild status of queried gene in Single Cancer Type}
\usage{
vis_toil_Mut_cancer(
  mut_Gene = "TP53",
  Gene = NULL,
  data_type = NULL,
  Mode = c("Dotplot", "Violinplot"),
  Show.P.value = TRUE,
  Show.P.label = TRUE,
  Method = c("wilcox.test", "t.test"),
  values = c("#DF2020", "#DDDF21"),
  draw_quantiles = c(0.25, 0.5, 0.75),
  trim = TRUE,
  Cancer = "ACC",
  opt_pancan = .opt_pancan
)
}
\arguments{
\item{mut_Gene}{the queried gene to determine grouping based on mutation and wild status}

\item{Gene}{a molecular identifier (e.g., "TP53") or a formula specifying
genomic signature (\code{"TP53 + 2 * KRAS - 1.3 * PTEN"}).}

\item{data_type}{choose gene profile type,
including "mRNA", "transcript", "methylation", "miRNA".}

\item{Mode}{choose one visualize mode to represent data}

\item{Show.P.value}{\code{TRUE} or \code{FALSE} whether to count P value}

\item{Show.P.label}{\code{TRUE} or \code{FALSE} present p value with number or label \code{*}, \verb{**}, \verb{***} and \verb{****}}

\item{Method}{default method is wilcox.test}

\item{values}{the color to fill mutation or wild status}

\item{draw_quantiles}{draw quantiles for violinplot}

\item{trim}{whether to trim the violin}

\item{Cancer}{select cancer cohort(s).}

\item{opt_pancan}{specify one dataset for some molercular profiles}
}
\value{
a \code{ggplot} object or a tibble data.frame.
}
\description{
Visualize molecular profile difference between mutation and wild status of queried gene in Single Cancer Type
}
