#' @name alba
#' @title Length-frequency data of the clam Abra alba
#' @description Length-frequency data of the clam Abra alba as presented
#' by Brey et al. (1988). Includes 7 approximately bi-monthly samplings of
#' A. alba binned into 14 length classes. The data is of class "lfq", which
#' can be used used e.g. in functions estimating growth parameters:
#' \code{\link[TropFishR]{ELEFAN}}, \code{\link[TropFishR]{ELEFAN_SA}} or
#' \code{\link[TropFishR]{ELEFAN_GA}}.
#'
#'
#' @docType data
#'
#' @format A list of class lfq consisting of:
#' \itemize{
#'   \item \strong{dates} dates of sampling times (class Date),
#'   \item \strong{midLengths} midpoints of the length classes,
#'   \item \strong{catch} matrix with catches/counts per length class (row) and sampling date (column).
#' }
#'
#' @source Brey, T., Soriano, M., and Pauly, D. 1988.
#' Electronic length frequency analysis: a revised and
#' expanded user's guide to ELEFAN 0, 1 and 2.
#' ICLARM Contrib. 261.
#'
#' @usage data(alba)
#' @keywords data dataset length-frequency
#'
#' @examples
#' data(alba)
#'
#' # plot raw catch frequencies
#' plot(alba, Fname = "catch")
#'
#' # plot restructured frequencies
#' alba <- lfqRestructure(alba, MA=5)
#' plot(alba, Fname = "rcounts")
#'
#' \donttest{
#' # ELEFAN_SA fitting
#' set.seed(1)
#' fitSA <- ELEFAN_SA(
#'   alba, seasonalised = TRUE,
#'   init_par = list(Linf=14.5, K=1.1, t_anchor=0.4, ts=0, C=0.2),
#'   low_par = list(Linf=13, K=0.7, t_anchor=0, ts=0, C=0),
#'   up_par = list(Linf=15.5, K=1.5, t_anchor=1, ts=1, C=1),
#'   SA_time = 60
#' )
#' unlist(fitSA$par)
#' fitSA$Rn_max
#'
#' # plot ELEFAN_SA results
#' plot(alba, Fname = "catch", draw = FALSE)
#' lfqFitCurves(fitSA, col=2, par=fitSA$par, draw=TRUE)$Rn_max
#' }
#'
NULL
