% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LBB.R
\name{plotLBB.year}
\alias{plotLBB.year}
\title{Plotting LBB fit (single year)}
\usage{
plotLBB.year(r.L.y, r.Freq.y, r.Lopt, SL1, SL2, MK, FK, Linf, Year,
  GausSel = FALSE)
}
\arguments{
\item{r.L.y}{Length classes relative to asymptotic length.}

\item{r.Freq.y}{Relative frequencies.}

\item{r.Lopt}{Optimum length relative to asymptotic length.}

\item{SL1}{Selectivity parameter 1}

\item{SL2}{Selectivity parameter 2}

\item{MK}{MK ratio}

\item{FK}{FK ratio}

\item{Linf}{Asymptotic length}

\item{Year}{Assessment year}

\item{GausSel}{Logical; indicating the selectivity pattern. If FALSE (default) trawl-like,
if TRUE gaussian selectivity is assumed.}
}
\description{
Function to plot LBB fit for a single year
}
\details{
Expects lengths relative to Linf (L/Linf).
}
\references{
R. Froese, H. Winker, G. Coro, N. Demirel, A.C. Tsikliras, D. Dimarchopoulou,
G. Scarcella, W.N. Probst, M. Dureuil, and D. Pauly (2018) A new approach
for estimating stock status from length frequency data. ICES Journal of Marine Science. DOI: 10.1093/icesjms/fsy078
}
