% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/powell_wetherall.R
\name{powell_wetherall}
\alias{powell_wetherall}
\title{Powell-Wetherall method}
\usage{
powell_wetherall(param, catch_columns = NA, savePlots = FALSE,
  reg_int = NULL, main = "Powell-Wetherall plot")
}
\arguments{
\item{param}{a list consisting of following parameters:
\itemize{
  \item  \code{midLengths}: midpoints of the length groups,
  \item \code{Linf}: infinite length for investigated species [cm],
  \item \code{K}: growth coefficent for investigated species [1/year],
  \item \code{t0}: theoretical time zero, at which individuals of this species hatch,
  \item \code{catch}: catch as vector, or a matrix with catches of subsequent years;
}}

\item{catch_columns}{optional; in case catch is a matrix or data.frame, a number
indicating which column of the matrix should be analysed (Default: \code{NA}).}

\item{savePlots}{logical; if TRUE the plot is recorded. Default is FALSE.}

\item{reg_int}{instead of using the identity method a range can be determined,
which is to be used for the regression analysis. If equal to NULL identity method
is applied (default).}

\item{main}{title of plot (Default is "Powell-Wetherall plot")}
}
\value{
A list with the input parameters and follwing objects:
\itemize{
  \item \strong{tmean} or \strong{Lmean}: mean age or length of fish,
  \item \strong{Z}: total mortality;}
and/or following objects when applying the Powell and Wetherall method:
\itemize{
  \item \strong{Lmean_Lprime}: dependent variable for regression analysis,
  \item \strong{Lprime}: some length for which all fish of that length and
     longer are under full exploitation,
  \item \strong{Linf_est}: infinite length in [cm] (Linf),
  \item \strong{se_Linf}: standard error of Linf,
  \item \strong{confidenceInt_Linf}: confidence interval for Linf,
  \item \strong{ZK}: total mortality divided by K (Z/K),
  \item \strong{se_ZK}: standard error of Z/K,
  \item \strong{confidenceInt_ZK}: confidence interval of Z/K;
}
}
\description{
A method to estimate the instantaneous total mortality rate (Z) and
   the infinite length of the von Bertalanffy growth equation
   (Powell, 1979; Wetherall et al., 1987).
}
\details{
The first length group or age class within the list object \code{midLengths} or
   \code{age} will be used as the Lprim or tprime (length of recruitment to fishery).
   This function includes the
   \code{identify} function, which asks you to choose two points from a graph manually. The
   two points which you choose by clicking on the plot in the graphical device represent
   the start and end of the data points, which should be used for the analysis. Based
   on these points the regression line is calculated. The Powell and Wetherall method
   only works with length-frequency data.
}
\examples{
\donttest{
data(synLFQ3)
powell_wetherall(synLFQ3)

data(synLFQ5)
powell_wetherall(synLFQ5, catch_columns = 1:12)
}

}
\references{
Powell, D.G., 1979. Estimation of mortality and growth parameters from the length-
frequency of a catch. \emph{Rapp.P.-v.Reun.CIEM}, 175:167-169

Sparre, P., Venema, S.C., 1998. Introduction to tropical fish stock assessment.
Part 1. Manual. \emph{FAO Fisheries Technical Paper}, (306.1, Rev. 2). 407 p.

Wetherall, J.A., J.J. Polovina and S. Ralston, 1987. Estimating growth and mortality
in steady-state fish stocks from length-frequency data. \emph{ICLARM Conf.Proc.},
(13):53-74
}
\keyword{Linf}
\keyword{Z/K}
\keyword{function}
\keyword{mortality}
