% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatchStrings.R
\name{MatchStrings}
\alias{MatchStrings}
\title{Check for mismatch between character vectors}
\usage{
MatchStrings(x, table, Fail = stop, max.distance = 0.5, ...)
}
\arguments{
\item{x, table}{Character vectors, in which all elements of \code{x} are expected
to occur in \code{table}.}

\item{Fail}{Function to call if a mismatch is found.}

\item{max.distance, \dots}{Arguments to \code{\link[base:agrep]{agrep()}},
used to propose possible matches to the user.}
}
\value{
\code{MatchStrings()} returns the elements of \code{x} that occur in \code{table}.
}
\description{
Checks that entries in one character vector occur in another, suggesting
corrections for mismatched elements.
}
\examples{
tree <- BalancedTree(8)
MatchStrings(c("t1", "tip2", "t3"), TipLabels(tree), Fail = message)
}
\seealso{
Other string parsing functions: 
\code{\link{EndSentence}()},
\code{\link{MorphoBankDecode}()},
\code{\link{RightmostCharacter}()},
\code{\link{Unquote}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{string parsing functions}
