% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Consensus.R
\name{Consensus}
\alias{Consensus}
\title{Construct consensus trees}
\usage{
Consensus(trees, p = 1, check.labels = TRUE)
}
\arguments{
\item{trees}{List of trees, optionally of class \code{multiPhylo}.}

\item{p}{Proportion of trees that must contain a split for it to be reported
in the consensus.  \code{p = 0.5} gives the majority-rule consensus; \code{p = 1} (the
default) gives the strict consensus.}

\item{check.labels}{Logical specifying whether to check that all trees have
identical labels.  Defaults to \code{TRUE}, which is slower.}
}
\value{
\code{Consensus()} returns an object of class \code{phylo}, rooted as in the
first entry of \code{trees}.
}
\description{
\code{Consensus()} calculates the consensus of a set of trees, using the
algorithm of \insertCite{Day1985}{TreeTools}.
}
\examples{
Consensus(as.phylo(0:2, 8))
}
\references{
\insertAllCited{}
}
\seealso{
\code{TreeDist::ConsensusInfo()} calculates the information content of a consensus
tree.

Other consensus tree functions: 
\code{\link{ConsensusWithout}()},
\code{\link{RoguePlot}()}

Other tree characterization functions: 
\code{\link{CladisticInfo}()},
\code{\link{J1Index}()},
\code{\link{Stemwardness}},
\code{\link{TotalCopheneticIndex}()}
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
\concept{consensus tree functions}
\concept{tree characterization functions}
