% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est-param-ztpois.R
\name{util_zero_truncated_poisson_param_estimate}
\alias{util_zero_truncated_poisson_param_estimate}
\title{Estimate Zero Truncated Poisson Parameters}
\usage{
util_zero_truncated_poisson_param_estimate(.x, .auto_gen_empirical = TRUE)
}
\arguments{
\item{.x}{The vector of data to be passed to the function. Must be non-negative
integers.}

\item{.auto_gen_empirical}{This is a boolean value of TRUE/FALSE with default
set to TRUE. This will automatically create the \code{tidy_empirical()} output
for the \code{.x} parameter and use the \code{tidy_combine_distributions()}. The user
can then plot out the data using \verb{$combined_data_tbl} from the function output.}
}
\value{
A tibble/list
}
\description{
This function will attempt to estimate the Zero Truncated Poisson
lambda parameter given some vector of values \code{.x}. The function will return a
tibble output, and if the parameter \code{.auto_gen_empirical} is set to \code{TRUE}
then the empirical data given to the parameter \code{.x} will be run through the
\code{tidy_empirical()} function and combined with the estimated Zero Truncated
Poisson data.
}
\details{
This function estimates the parameter lambda of a Zero-Truncated Poisson distribution
based on a vector of non-negative integer values \code{.x}. The Zero-Truncated Poisson
distribution is a discrete probability distribution that models the number of events
occurring in a fixed interval of time, given that at least one event has occurred.

The estimation is performed by minimizing the negative log-likelihood of the observed
data \code{.x} under the Zero-Truncated Poisson model. The negative log-likelihood function
used for optimization is defined as:

\deqn{-\sum_{i=1}^{n} \log(P(X_i = x_i \mid X_i > 0, \lambda))}{,}

where \( X_i \) are the observed values in \code{.x} and \code{lambda} is the parameter
of the Zero-Truncated Poisson distribution.

The optimization process uses the \code{optim} function to find the value of \code{lambda}
that minimizes this negative log-likelihood. The chosen optimization method is Brent's
method (\code{method = "Brent"}) within a specified interval \verb{[0, max(.x)]}.

If \code{.auto_gen_empirical} is set to \code{TRUE}, the function will generate empirical data
statistics using \code{tidy_empirical()} for the input data \code{.x} and then combine this
empirical data with the estimated Zero-Truncated Poisson distribution using
\code{tidy_combine_distributions()}. This combined data can be accessed via the
\verb{$combined_data_tbl} element of the function output.

The function returns a tibble containing the estimated parameter \code{lambda} along
with other summary statistics of the input data (sample size, minimum, maximum).
}
\examples{
library(dplyr)
library(ggplot2)

tc <- tidy_zero_truncated_poisson() |> pull(y)
output <- util_zero_truncated_poisson_param_estimate(tc)

output$parameter_tbl

output$combined_data_tbl |>
  tidy_combined_autoplot()

}
\seealso{
Other Parameter Estimation: 
\code{\link{util_bernoulli_param_estimate}()},
\code{\link{util_beta_param_estimate}()},
\code{\link{util_binomial_param_estimate}()},
\code{\link{util_burr_param_estimate}()},
\code{\link{util_cauchy_param_estimate}()},
\code{\link{util_chisquare_param_estimate}()},
\code{\link{util_exponential_param_estimate}()},
\code{\link{util_f_param_estimate}()},
\code{\link{util_gamma_param_estimate}()},
\code{\link{util_generalized_beta_param_estimate}()},
\code{\link{util_generalized_pareto_param_estimate}()},
\code{\link{util_geometric_param_estimate}()},
\code{\link{util_hypergeometric_param_estimate}()},
\code{\link{util_inverse_burr_param_estimate}()},
\code{\link{util_inverse_pareto_param_estimate}()},
\code{\link{util_inverse_weibull_param_estimate}()},
\code{\link{util_logistic_param_estimate}()},
\code{\link{util_lognormal_param_estimate}()},
\code{\link{util_negative_binomial_param_estimate}()},
\code{\link{util_normal_param_estimate}()},
\code{\link{util_paralogistic_param_estimate}()},
\code{\link{util_pareto1_param_estimate}()},
\code{\link{util_pareto_param_estimate}()},
\code{\link{util_poisson_param_estimate}()},
\code{\link{util_t_param_estimate}()},
\code{\link{util_triangular_param_estimate}()},
\code{\link{util_uniform_param_estimate}()},
\code{\link{util_weibull_param_estimate}()},
\code{\link{util_zero_truncated_binomial_param_estimate}()},
\code{\link{util_zero_truncated_geometric_param_estimate}()},
\code{\link{util_zero_truncated_negative_binomial_param_estimate}()}

Other Poisson: 
\code{\link{tidy_poisson}()},
\code{\link{tidy_zero_truncated_poisson}()},
\code{\link{util_poisson_param_estimate}()},
\code{\link{util_poisson_stats_tbl}()},
\code{\link{util_zero_truncated_poisson_stats_tbl}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Parameter Estimation}
\concept{Poisson}
