% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calib_param.R
\name{calib_param}
\alias{calib_param}
\title{Automatic calibration of trip distribution laws' parameter}
\usage{
calib_param(av_surf, law = "NGravExp")
}
\arguments{
\item{av_surf}{A positive \code{numeric} value indicating the average surface
area of the locations (in square kilometers).}

\item{law}{A \code{character} string indicating which law to use (see Details).}
}
\value{
An estimate of the optimal parameter value based on
the average surface area of the locations.
}
\description{
This function returns an estimate of the optimal parameter value based on
the average surface area of the locations (in square kilometers) according
to the law. This estimation has only been tested on commuting data
(in kilometers).
}
\details{
The estimation is based on Figure 8 in Lenormand \emph{et al.}
(2016) for four types of laws: the normalized gravity law with an exponential
distance decay function (\code{law = "NGravExp"}), the normalized gravity law with
a power distance decay function (\code{law = "NGravPow"}), Schneider's
intervening opportunities law (\code{law = "Schneider"}), and the extended
radiation law (\code{law = "RadExt"}).
}
\examples{
data(county)

res <- extract_spatial_information(county, id = "ID")
av_surf <- mean(res$surface)

calib_param(av_surf = av_surf, law = "NGravExp")
calib_param(av_surf = av_surf, law = "NGravPow")
calib_param(av_surf = av_surf, law = "Schneider")
calib_param(av_surf = av_surf, law = "RadExt")

}
\references{
Lenormand M, Bassolas A, Ramasco JJ (2016) Systematic comparison of trip
distribution laws and models. \emph{Journal of Transport Geography} 51,
158-169.
}
\seealso{
Associated functions:
\code{\link[=extract_opportunities]{extract_opportunities()}} \code{\link[=extract_spatial_information]{extract_spatial_information()}}
\code{\link[=check_format_names]{check_format_names()}}
}
\author{
Maxime Lenormand (\email{maxime.lenormand@inrae.fr})
}
