% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_median22Y.R
\name{imagemed22Y}
\alias{imagemed22Y}
\title{Wasserstein Median of Images by You et al. (2022)}
\usage{
imagemed22Y(images, weights = NULL, lambda = NULL, ...)
}
\arguments{
\item{images}{a length-\eqn{N} list of same-size image matrices of size \eqn{(m\times n)}.}

\item{weights}{a weight of each image; if \code{NULL} (default), uniform weight is set. Otherwise,
it should be a length-\eqn{N} vector of nonnegative weights.}

\item{lambda}{a regularization parameter; if \code{NULL} (default), a paper's suggestion
would be taken, or it should be a nonnegative real number.}

\item{...}{extra parameters including \describe{
\item{abstol}{stopping criterion for iterations (default: 1e-8).}
\item{init.image}{an initial weight image (default: uniform weight).}
\item{maxiter}{maximum number of iterations (default: 496).}
\item{nthread}{number of threads for OpenMP run (default: 1).}
\item{print.progress}{a logical to show current iteration (default: \code{TRUE}).}
}}
}
\value{
an \eqn{(m\times n)} matrix of the Wasserstein median image.
}
\description{
Given multiple images \eqn{X_1,\ldots,X_N}, the Wasserstein median of
order 2 is computed. The proposed method relies on a choice of barycenter computation
in that we opt for an algorithm of \code{\link{imagebary15B}}, which uses
entropic regularization for barycenter computation. Please note the followings; (1) we only take a matrix as an image so please
make it grayscale if not, (2) all images should be of same size - no resizing is performed.
}
\examples{
\dontrun{
#----------------------------------------------------------------------
#                       MNIST Data with Digit 3
#
# EXAMPLE : Very Small Example for CRAN; just showing how to use it!
#----------------------------------------------------------------------
# LOAD THE DATA
data(digit3)
datsmall = digit3[1:10]
 
# COMPUTE
outsmall = imagemed22Y(datsmall, maxiter=5)

# VISUALIZE
opar <- par(no.readonly=TRUE)
par(mfrow=c(1,4), pty="s")
image(outsmall, xaxt='n', yaxt='n', main="Wasserstein Median")
image(datsmall[[3]], xaxt='n', yaxt='n', main="3rd image")
image(datsmall[[6]], xaxt='n', yaxt='n', main="6th image")
image(datsmall[[9]], xaxt='n', yaxt='n', main="9th image")
par(opar)
} 

}
\concept{image}
