% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rsq.R
\name{rsq}
\alias{rsq}
\title{A function to calculate most of the available pseudo R-squared measures}
\usage{
rsq(
  model,
  full_model = NULL,
  data,
  which = c("Surrogate", "McFadden", "McKelveyZavoina", "CoxSnell", "Nagelkerke", "Tjur"),
  avg.num = 30,
  ...
)
}
\arguments{
\item{model}{A reduced or working model that needs to be investigated. The reported surrogate
R-square is for this reduced model.}

\item{full_model}{A full model that needs to be specified for the surrogate R-square approach.}

\item{data}{A data set contains the categorical responses and all necessary predictors
(including all the predictors in the \code{full_model}).}

\item{which}{An argument to specify which pseudo R-squared to calculate. This package supports
surrogate R-squared, McFadden R-squared, McKelveyZavoina R-squared,
CoxSnell R-squared, Nagelkerke R-squared, and Tjur R-squared.}

\item{avg.num}{The number of replication for the averaging of surrogate R-square.}

\item{...}{Additional optional arguments.}
}
\value{
An object of class \code{"surr_rsq"} when \code{which = "Surrogate"}, or a R-squared value
when other pseudo R-squared are specified.
}
\description{
A function to include most of the available pseudo R-squared measures including Surrogate R-squared, McFadden R-squared, McKelveyZavoina R-squared, CoxSnell R-squared, Nagelkerke R-squared, and Tjur R-squared.
}
\examples{
data("RedWine")

full_formula <- as.formula(quality ~ fixed.acidity + volatile.acidity + citric.acid
+ residual.sugar + chlorides + free.sulfur.dioxide +
total.sulfur.dioxide + density + pH + sulphates + alcohol)

model <- polr(formula = full_formula, data=RedWine, method  = "probit")

rsq(model=model, data=RedWine, which="McKelveyZavoina")

}
